/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;

public class AttributeTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("attribute");
    public static final ITraitSerializer<AttributeTrait> SERIALIZER = new SimpleTrait.Serializer<AttributeTrait>(SERIALIZER_ID, AttributeTrait::new, AttributeTrait::readJson, AttributeTrait::readBuffer, AttributeTrait::writeBuffer);
    private final Map<String, List<ModifierData>> modifiers = new HashMap<String, List<ModifierData>>();

    public AttributeTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> map, String slot) {
        int traitLevel = context.getTraitLevel();
        for (Map.Entry<String, List<ModifierData>> entry : this.modifiers.entrySet()) {
            String key = entry.getKey();
            List<ModifierData> mods = entry.getValue();
            if (!AttributeTrait.gearMatchesKey(context.getGear(), key, slot)) continue;
            for (ModifierData mod : mods) {
                Attribute attribute = mod.getAttribute();
                if (attribute == null) continue;
                String modName = String.format("%s_%s_%d_%s_%s", this.getId().m_135827_(), this.getId().m_135815_(), traitLevel, mod.name, key);
                float modValue = mod.values[Mth.m_14045_((int)(traitLevel - 1), (int)0, (int)(mod.values.length - 1))];
                map.put((Object)attribute, (Object)new AttributeModifier(mod.getUuid(slot), modName, (double)modValue, mod.operation));
            }
        }
    }

    private static boolean gearMatchesKey(ItemStack gear, String key, String slotType) {
        String[] parts = key.split("/");
        if (parts.length > 2) {
            return false;
        }
        GearType gearType = GearHelper.getType(gear);
        return gearType.matches(parts[0]) && (parts.length < 2 || slotType.equals(parts[1])) && GearHelper.isValidSlot(gear, slotType);
    }

    private static void readJson(AttributeTrait trait, JsonObject json) {
        if (!json.has("attribute_modifiers")) {
            throw new JsonParseException("Attribute trait '" + trait.getId() + "' is missing 'attribute_modifiers' object");
        }
        JsonObject jsonModifiers = json.getAsJsonObject("attribute_modifiers");
        for (Map.Entry entry : jsonModifiers.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<ModifierData> list = new ArrayList<ModifierData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(ModifierData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.modifiers.put(key, list);
        }
    }

    private static void readBuffer(AttributeTrait trait, FriendlyByteBuf buffer) {
        trait.modifiers.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<ModifierData> list = new ArrayList<ModifierData>();
            String gearType = buffer.m_130277_();
            int dataCount = buffer.readByte();
            for (int dataIndex = 0; dataIndex < dataCount; ++dataIndex) {
                list.add(ModifierData.read(buffer));
            }
            trait.modifiers.put(gearType, list);
        }
    }

    private static void writeBuffer(AttributeTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.modifiers.size());
        for (Map.Entry<String, List<ModifierData>> entry : trait.modifiers.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (ModifierData data : entry.getValue()) {
                data.write(buffer);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.modifiers.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class ModifierData {
        private ResourceLocation name;
        private float[] values;
        private AttributeModifier.Operation operation = AttributeModifier.Operation.ADDITION;
        private final Map<String, UUID> uuidMap = new HashMap<String, UUID>();

        public static ModifierData of(Attribute attribute, AttributeModifier.Operation operation, float ... values) {
            ModifierData ret = new ModifierData();
            ret.name = attribute.getRegistryName();
            ret.operation = operation;
            ret.values = (float[])values.clone();
            return ret;
        }

        public UUID getUuid(String slot) {
            return this.uuidMap.computeIfAbsent(slot, slot1 -> new UUID(this.name.hashCode(), slot1.hashCode()));
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("attribute", this.name.toString());
            json.addProperty("operation", (Number)this.operation.m_22235_());
            JsonArray array = new JsonArray();
            for (float f : this.values) {
                array.add((Number)Float.valueOf(f));
            }
            json.add("value", (JsonElement)array);
            return json;
        }

        static ModifierData from(JsonObject json) {
            ModifierData ret = new ModifierData();
            if (!json.has("attribute")) {
                throw new JsonParseException("attribute element not found, should be string");
            }
            ret.name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"attribute"));
            JsonElement element = json.get("value");
            if (element.isJsonPrimitive()) {
                ret.values = new float[]{GsonHelper.m_13915_((JsonObject)json, (String)"value")};
            } else if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ret.values = new float[array.size()];
                for (int i = 0; i < ret.values.length; ++i) {
                    ret.values[i] = array.get(i).getAsFloat();
                }
            } else {
                throw new JsonParseException("value element not found, should be either float or array");
            }
            ret.operation = AttributeModifier.Operation.m_22236_((int)GsonHelper.m_13824_((JsonObject)json, (String)"operation", (int)0));
            return ret;
        }

        static ModifierData read(FriendlyByteBuf buffer) {
            ModifierData ret = new ModifierData();
            ret.name = buffer.m_130281_();
            ret.values = new float[buffer.readByte()];
            for (int i = 0; i < ret.values.length; ++i) {
                ret.values[i] = buffer.readFloat();
            }
            ret.operation = (AttributeModifier.Operation)buffer.m_130066_(AttributeModifier.Operation.class);
            return ret;
        }

        void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.name);
            buffer.writeByte(this.values.length);
            for (float f : this.values) {
                buffer.writeFloat(f);
            }
            buffer.m_130068_((Enum)this.operation);
        }

        @Nullable
        public Attribute getAttribute() {
            return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(this.name);
        }

        private String getWikiLine() {
            CharSequence[] valueText = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valueText[i] = Float.toString(this.values[i]);
            }
            return this.name + ": " + this.operation.name() + " [" + String.join((CharSequence)", ", valueText) + "]";
        }
    }
}

