/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.ItemStats;

public abstract class ChargedMaterialModifier
implements IMaterialModifier {
    protected final IMaterialInstance material;
    protected final int level;

    protected ChargedMaterialModifier(IMaterialInstance material, int level) {
        this.material = material;
        this.level = level;
    }

    public ChargedProperties getChargedProperties() {
        return new ChargedProperties(this.level, this.material.getStat(PartType.MAIN, ItemStats.CHARGEABILITY));
    }

    public static class Type<T extends ChargedMaterialModifier>
    implements IMaterialModifierType<T> {
        private final BiFunction<IMaterialInstance, Integer, T> factory;
        private final String nbtTagName;

        public Type(BiFunction<IMaterialInstance, Integer, T> factory, String nbtTagName) {
            this.factory = factory;
            this.nbtTagName = nbtTagName;
        }

        public int checkLevel(ItemStack stack) {
            return stack.m_41784_().m_128448_(this.nbtTagName);
        }

        public T create(IMaterialInstance material, int level) {
            return (T)((ChargedMaterialModifier)this.factory.apply(material, level));
        }

        @Override
        public void removeModifier(ItemStack stack) {
            if (!stack.m_41619_()) {
                stack.m_41784_().m_128473_(this.nbtTagName);
                stack.m_41784_().m_128473_("SG_IsFoil");
            }
        }

        boolean causesFoilEffect() {
            return true;
        }

        @Override
        @Nullable
        public IMaterialModifier read(IMaterialInstance material) {
            short level = material.getItem().m_41784_().m_128448_(this.nbtTagName);
            if (level == 0) {
                return null;
            }
            return (IMaterialModifier)this.factory.apply(material, Integer.valueOf(level));
        }

        @Override
        public void write(T modifier, ItemStack stack) {
            stack.m_41784_().m_128376_(this.nbtTagName, (short)((ChargedMaterialModifier)modifier).level);
            if (this.causesFoilEffect()) {
                stack.m_41784_().m_128379_("SG_IsFoil", true);
            }
        }
    }
}

