/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.DefaultMaterialDisplay;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.utils.EnumUtils;

public class LazyMaterialInstance
implements IMaterialInstance {
    private final ResourceLocation materialId;
    private final MaterialGrade grade;

    public LazyMaterialInstance(ResourceLocation materialId) {
        this(materialId, MaterialGrade.NONE);
    }

    public LazyMaterialInstance(ResourceLocation materialId, MaterialGrade grade) {
        this.materialId = materialId;
        this.grade = grade;
    }

    public static LazyMaterialInstance of(DataResource<IMaterial> material) {
        return new LazyMaterialInstance(material.getId());
    }

    public static LazyMaterialInstance of(ResourceLocation materialId) {
        return new LazyMaterialInstance(materialId);
    }

    public static LazyMaterialInstance of(DataResource<IMaterial> material, MaterialGrade grade) {
        return new LazyMaterialInstance(material.getId(), grade);
    }

    public static LazyMaterialInstance of(ResourceLocation materialId, MaterialGrade grade) {
        return new LazyMaterialInstance(materialId, grade);
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    @Nullable
    public IMaterial get() {
        return MaterialManager.get(this.materialId);
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        IMaterial material = this.get();
        return material != null ? MaterialInstance.of(material).getItem() : ItemStack.f_41583_;
    }

    @Override
    public int getTier(PartType partType) {
        IMaterial material = this.get();
        return material != null ? material.getTier(this, partType) : 0;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("ID", this.materialId.toString());
        if (this.grade != MaterialGrade.NONE) {
            nbt.m_128359_("Grade", this.grade.name());
        }
        return nbt;
    }

    @Override
    public Component getDisplayName(PartType partType, ItemStack gear) {
        IMaterial material = this.get();
        return material != null ? material.getDisplayName(this, partType, gear) : new TextComponent("INVALID");
    }

    @Override
    public String getModelKey() {
        return "null";
    }

    @Override
    public IMaterialDisplay getDisplayProperties() {
        IMaterial mat = this.get();
        return mat != null ? mat.getDisplayProperties(this) : DefaultMaterialDisplay.INSTANCE;
    }

    public static LazyMaterialInstance deserialize(JsonObject json) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"material"));
        MaterialGrade grade = (MaterialGrade)EnumUtils.byName((String)GsonHelper.m_13851_((JsonObject)json, (String)"grade", (String)"NONE"), (Enum)MaterialGrade.NONE);
        return new LazyMaterialInstance(id, grade);
    }

    public static LazyMaterialInstance read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        MaterialGrade grade = (MaterialGrade)buffer.m_130066_(MaterialGrade.class);
        return new LazyMaterialInstance(id, grade);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.materialId);
        buffer.m_130068_((Enum)this.grade);
    }
}

