/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.data.trait.TraitBuilder;
import net.silentchaos512.gear.gear.trait.StatModifierTrait;
import net.silentchaos512.gear.util.DataResource;

public class StatModifierTraitBuilder
extends TraitBuilder {
    private final Map<IItemStat, StatModifierTrait.StatMod> mods = new LinkedHashMap<IItemStat, StatModifierTrait.StatMod>();

    public StatModifierTraitBuilder(DataResource<ITrait> trait, int maxLevel) {
        this(trait.getId(), maxLevel);
    }

    public StatModifierTraitBuilder(ResourceLocation traitId, int maxLevel) {
        super(traitId, maxLevel, StatModifierTrait.SERIALIZER);
    }

    public StatModifierTraitBuilder addStatMod(IItemStat stat, float multi, boolean factorDamage, boolean factorValue) {
        this.mods.put(stat, StatModifierTrait.StatMod.of(multi, factorDamage, factorValue));
        return this;
    }

    @Override
    public JsonObject serialize() {
        if (this.mods.isEmpty()) {
            throw new IllegalStateException("Stat modifier trait '" + this.traitId + "' has no modifiers");
        }
        JsonObject json = super.serialize();
        JsonArray statsJson = new JsonArray();
        this.mods.forEach((stat, mod) -> statsJson.add((JsonElement)mod.serialize((IItemStat)stat)));
        json.add("stats", (JsonElement)statsJson);
        return json;
    }
}

