/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.lib.util.NameUtils;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "silentgear", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Silent Gear - Item Models";
    }

    protected void registerModels() {
        Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(this::blockItemModel);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        for (CraftingItems item : CraftingItems.values()) {
            this.builder(item, (ModelFile)itemGenerated, "item/" + item.getName());
        }
        this.builder((ItemLike)ModItems.NETHERWOOD_CHARCOAL, (ModelFile)itemGenerated);
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.SHEET_METAL).parent((ModelFile)itemGenerated)).texture("layer0", "item/sheet_metal")).texture("layer1", "item/sheet_metal_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.ALLOY_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.HYBRID_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        this.builder((ItemLike)ModItems.MIXED_FABRIC, (ModelFile)itemGenerated, "item/mixed_fabric");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.CUSTOM_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.CUSTOM_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)ModItems.BLUEPRINT_BOOK).parent((ModelFile)itemGenerated)).texture("layer0", "item/blueprint_book_cover")).texture("layer1", "item/blueprint_book_pages")).texture("layer2", "item/blueprint_book_deco");
        this.builder((ItemLike)ModItems.JEWELER_TOOLS, (ModelFile)itemGenerated, "item/jeweler_tools");
        Registration.getItems(PartBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        Registration.getItems(GearBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        this.builder((ItemLike)ModItems.MOD_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.VERY_CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.STURDY_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.CRIMSON_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.AZURE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.GUIDE_BOOK, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.BLUEPRINT_PACKAGE, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.FLAX_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.FLUFFY_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.GOLDEN_NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)ModItems.PEBBLE, (ModelFile)itemGenerated);
    }

    private void blockItemModel(Block block) {
        if (block == ModBlocks.FLAX_PLANT.get() || block == ModBlocks.FLUFFY_PLANT.get()) {
            return;
        }
        if (block == ModBlocks.PHANTOM_LIGHT.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/phantom_light");
        } else if (block == ModBlocks.NETHERWOOD_SAPLING.get() || block == ModBlocks.STONE_TORCH.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "block/" + NameUtils.from((IForgeRegistryEntry)block).m_135815_());
        } else if (block == ModBlocks.NETHERWOOD_FENCE.get()) {
            this.withExistingParent("netherwood_fence", this.modLoc("block/netherwood_fence_inventory"));
        } else if (block == ModBlocks.NETHERWOOD_DOOR.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/netherwood_door");
        } else if (block == ModBlocks.NETHERWOOD_TRAPDOOR.get()) {
            this.withExistingParent("netherwood_trapdoor", this.modLoc("block/netherwood_trapdoor_bottom"));
        } else if (block.m_5456_() != Items.f_41852_) {
            String name = NameUtils.from((IForgeRegistryEntry)block).m_135815_();
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private ItemModelBuilder builder(ItemLike item) {
        return (ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_());
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent) {
        String name = NameUtils.fromItem((ItemLike)item).m_135815_();
        return this.builder(item, parent, "item/" + name);
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_())).parent(parent)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, GearBlueprintItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getGearType().getName());
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, PartBlueprintItem item) {
        if (item.hasStandardModel()) {
            ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getPartType().getName().m_135815_());
        }
    }
}

