/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "silentgear", exFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Silent Gear - Block States/Models";
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.BORT_ORE.get());
        this.simpleBlock((Block)ModBlocks.DEEPSLATE_BORT_ORE.get());
        this.simpleBlock((Block)ModBlocks.CRIMSON_IRON_ORE.get());
        this.simpleBlock((Block)ModBlocks.AZURE_SILVER_ORE.get());
        this.simpleBlock((Block)ModBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.BORT_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.CRIMSON_IRON_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.CRIMSON_STEEL_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.BLAZE_GOLD_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.AZURE_SILVER_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.TYRIAN_STEEL_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.NETHERWOOD_PLANKS.get());
        this.simpleBlock((Block)ModBlocks.NETHERWOOD_LEAVES.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.NETHERWOOD_LOG.get(), this.modLoc("block/netherwood_log"), this.modLoc("block/netherwood_log_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_NETHERWOOD_LOG.get(), this.modLoc("block/stripped_netherwood_log"), this.modLoc("block/stripped_netherwood_log_top"));
        this.simpleBlock((Block)ModBlocks.NETHERWOOD_WOOD.get(), (ModelFile)this.models().cubeAll("netherwood_wood", this.modLoc("block/netherwood_log")));
        this.simpleBlock((Block)ModBlocks.STRIPPED_NETHERWOOD_WOOD.get(), (ModelFile)this.models().cubeAll("stripped_netherwood_wood", this.modLoc("block/stripped_netherwood_log")));
        this.simpleBlock((Block)ModBlocks.NETHERWOOD_SAPLING.get(), (ModelFile)this.models().cross("netherwood_sapling", this.modLoc("block/netherwood_sapling")));
        ResourceLocation planks = this.modLoc("block/netherwood_planks");
        this.slabBlock((SlabBlock)ModBlocks.NETHERWOOD_SLAB.get(), planks, planks);
        this.stairsBlock((StairBlock)ModBlocks.NETHERWOOD_STAIRS.get(), planks);
        this.fenceBlock((FenceBlock)ModBlocks.NETHERWOOD_FENCE.get(), planks);
        this.fenceGateBlock((FenceGateBlock)ModBlocks.NETHERWOOD_FENCE_GATE.get(), planks);
        this.doorBlock((DoorBlock)ModBlocks.NETHERWOOD_DOOR.get(), this.modLoc("block/netherwood_door_bottom"), this.modLoc("block/netherwood_door_top"));
        this.trapdoorBlock((TrapDoorBlock)ModBlocks.NETHERWOOD_TRAPDOOR.get(), this.modLoc("block/netherwood_trapdoor"), true);
        this.simpleBlock((Block)ModBlocks.WHITE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.LIME_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.PINK_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.GRAY_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.CYAN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.BLUE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.BROWN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.GREEN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.RED_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.BLACK_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)ModBlocks.PHANTOM_LIGHT.get(), (ModelFile)this.models().cubeAll("phantom_light", this.modLoc("item/blank")));
        this.simpleBlock((Block)ModBlocks.POTTED_NETHERWOOD_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_netherwood_sapling", "block/flower_pot_cross")).texture("plant", "block/netherwood_sapling"));
        this.simpleBlock((Block)ModBlocks.STONE_TORCH.get(), (ModelFile)this.models().torch("stone_torch", this.modLoc("block/stone_torch")));
        this.getVariantBuilder((Block)ModBlocks.WALL_STONE_TORCH.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.wallTorch("wall_stone_torch", this.modLoc("block/stone_torch"))).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90).build());
        this.simpleBlock((Block)ModBlocks.GEAR_SMITHING_TABLE.get(), (ModelFile)this.getExistingModel("gear_smithing_table"));
        this.simpleBlock((Block)ModBlocks.STARLIGHT_CHARGER.get(), (ModelFile)this.getExistingModel("starlight_charger"));
        this.orientableMachineBlock((IBlockProvider)ModBlocks.MATERIAL_GRADER, "material_grader");
        this.orientableMachineBlock((IBlockProvider)ModBlocks.METAL_PRESS, "metal_press");
        this.orientableMachineBlock((IBlockProvider)ModBlocks.SALVAGER, "salvager");
        this.orientableMachineBlock((IBlockProvider)ModBlocks.METAL_ALLOYER, "metal_alloyer");
        this.orientableMachineBlock((IBlockProvider)ModBlocks.RECRYSTALLIZER, "recrystallizer");
        this.orientableMachineBlock((IBlockProvider)ModBlocks.REFABRICATOR, "refabricator");
        this.getVariantBuilder((Block)ModBlocks.FLAX_PLANT.get()).forAllStates(state -> {
            int i = ModBlockStateProvider.cropAgeToIndex((Integer)state.m_61143_((Property)ModCropBlock.f_52244_));
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().crop("flax_plant" + i, this.modLoc("block/flax_plant" + i))).build();
        });
        this.simpleBlock((Block)ModBlocks.WILD_FLAX_PLANT.get(), (ModelFile)this.models().crop("wild_flax_plant", this.modLoc("block/flax_plant3")));
        this.getVariantBuilder((Block)ModBlocks.FLUFFY_PLANT.get()).forAllStates(state -> {
            int i = ModBlockStateProvider.cropAgeToIndex((Integer)state.m_61143_((Property)ModCropBlock.f_52244_));
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().crop("fluffy_plant" + i, this.modLoc("block/fluffy_plant" + i))).build();
        });
        this.simpleBlock((Block)ModBlocks.WILD_FLUFFY_PLANT.get(), (ModelFile)this.models().crop("wild_fluffy_plant", this.modLoc("block/fluffy_plant3")));
    }

    private ModelFile.ExistingModelFile getExistingModel(String blockName) {
        return this.models().getExistingFile(this.modLoc(blockName));
    }

    private void orientableMachineBlock(IBlockProvider block, String name) {
        ModelFile.ExistingModelFile offModel = this.getExistingModel(name);
        ModelFile.ExistingModelFile onModel = this.getExistingModel(name + "_on");
        this.getVariantBuilder(block.asBlock()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            boolean lit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
            return ConfiguredModel.builder().modelFile((ModelFile)(lit ? onModel : offModel)).rotationY((int)facing.m_122424_().m_122435_()).build();
        });
    }

    public ModelBuilder<BlockModelBuilder> wallTorch(String name, ResourceLocation torch) {
        return this.models().singleTexture(name, this.mcLoc("block/wall_torch"), "torch", torch);
    }

    private static int cropAgeToIndex(int age) {
        if (age > 6) {
            return 3;
        }
        if (age > 3) {
            return 2;
        }
        if (age > 1) {
            return 1;
        }
        return 0;
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        super.fenceBlock(block, texture);
        ((BlockModelBuilder)this.models().withExistingParent(NameUtils.from((IForgeRegistryEntry)block).m_135815_() + "_inventory", this.mcLoc("block/fence_inventory"))).texture("texture", texture);
    }
}

