/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.event.GearEvents;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.gear.trait.DurabilityTrait;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.advancements.GenericIntTrigger;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModAdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ModAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.m_138327_());
            }
            Path path1 = ModAdvancementProvider.getPath(path, p_204017_3_);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)p_204017_3_.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new Advancements().accept(consumer);
    }

    public String m_6055_() {
        return "Silent Gear - Advancements";
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    private static class Advancements
    implements Consumer<Consumer<Advancement>> {
        private Advancements() {
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            ItemStack rootIcon = new ItemStack(ModItems.PICKAXE);
            GearData.writeConstructionParts(rootIcon, (Collection<? extends IPartData>)ImmutableList.of((Object)LazyPartData.of(Const.Parts.PICKAXE_HEAD, (CompoundPartItem)ModItems.PICKAXE_HEAD.get(), Const.Materials.CRIMSON_STEEL), (Object)LazyPartData.of(Const.Parts.ROD, (CompoundPartItem)ModItems.ROD.get(), Const.Materials.BLAZE_GOLD), (Object)LazyPartData.of(Const.Parts.TIP, (CompoundPartItem)ModItems.TIP.get(), Const.Materials.AZURE_ELECTRUM), (Object)LazyPartData.of(Const.Parts.GRIP, (CompoundPartItem)ModItems.GRIP.get(), Const.Materials.WOOL_BLACK), (Object)LazyPartData.of(Const.Parts.BINDING, (CompoundPartItem)ModItems.BINDING.get(), Const.Materials.STRING)));
            Advancement root = Advancement.Builder.m_138353_().m_138362_(rootIcon, Advancements.title("root"), Advancements.description("root"), new ResourceLocation("minecraft:textures/gui/advancements/backgrounds/adventure.png"), FrameType.TASK, false, false, false).m_138386_("get_item", Advancements.getItem(new ItemLike[]{Items.f_41960_})).m_138389_(consumer, Advancements.id("root"));
            Advancement overworldPlants = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)CraftingItems.FLAX_FIBER, Advancements.title("overworld_plants"), Advancements.description("overworld_plants"), null, FrameType.TASK, true, true, false).m_138386_("flax_seeds", Advancements.getItem(new ItemLike[]{ModItems.FLAX_SEEDS})).m_138386_("flax_fibers", Advancements.getItem(CraftingItems.FLAX_FIBER)).m_138386_("fluffy_seeds", Advancements.getItem(new ItemLike[]{ModItems.FLUFFY_SEEDS})).m_138386_("fluffy_puffs", Advancements.getItem(CraftingItems.FLUFFY_PUFF)).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, Advancements.id("overworld_plants"));
            Advancement kachink1 = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)Items.f_42749_, Advancements.title("kachink1"), Advancements.description("kachink1"), null, FrameType.TASK, true, true, false).m_138386_("kachink", Advancements.genericInt(GearHelper.DAMAGE_FACTOR_CHANGE, 1)).m_138389_(consumer, Advancements.id("kachink1"));
            Advancement kachink2 = Advancement.Builder.m_138353_().m_138398_(kachink1).m_138371_((ItemLike)CraftingItems.DIAMOND_SHARD, Advancements.title("kachink2"), Advancements.description("kachink2"), null, FrameType.TASK, true, true, false).m_138386_("kachink", Advancements.genericInt(DurabilityTrait.TRIGGER_BRITTLE, 1)).m_138389_(consumer, Advancements.id("kachink2"));
            Advancement crudeTool = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)CraftingItems.ROUGH_ROD, Advancements.title("crude_tool"), Advancements.description("crude_tool"), null, FrameType.TASK, true, true, false).m_138386_("tool_has_rough_rod", Advancements.genericInt(GearEvents.CRAFTED_WITH_ROUGH_ROD, 1)).m_138389_(consumer, Advancements.id("crude_tool"));
            Advancement survivalTool = Advancement.Builder.m_138353_().m_138398_(crudeTool).m_138371_(ModItems.KNIFE, Advancements.title("survival_tool"), Advancements.description("survival_tool"), null, FrameType.TASK, true, true, false).m_138386_("knife", Advancements.getItem(new ItemLike[]{ModItems.KNIFE})).m_138386_("dagger", Advancements.getItem(new ItemLike[]{ModItems.DAGGER})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, Advancements.id("survival_tool"));
            Advancement templateBoard = Advancements.simpleGetItem(consumer, CraftingItems.TEMPLATE_BOARD, survivalTool);
            Advancement blueprintPaper = Advancements.simpleGetItem(consumer, CraftingItems.BLUEPRINT_PAPER, templateBoard);
            Advancement upgradeBase = Advancements.simpleGetItem(consumer, CraftingItems.UPGRADE_BASE, templateBoard);
            Advancement.Builder builder = Advancement.Builder.m_138353_().m_138398_(templateBoard).m_138371_(ModItems.CRUDE_REPAIR_KIT, Advancements.title("repair_kit"), Advancements.description("repair_kit"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_);
            Registration.getItems(RepairKitItem.class).forEach(item -> builder.m_138386_(NameUtils.fromItem((ItemLike)item).m_135815_(), Advancements.getItem(new ItemLike[]{item})));
            Advancement repairKit = builder.m_138389_(consumer, Advancements.id("repair_kit"));
            Advancement crimsonRepairKit = Advancements.simpleGetItem(consumer, ModItems.CRIMSON_REPAIR_KIT, repairKit);
            Advancement azureRepairKit = Advancements.simpleGetItem(consumer, ModItems.AZURE_REPAIR_KIT, crimsonRepairKit);
            Advancement repairFromBroken = Advancement.Builder.m_138353_().m_138398_(repairKit).m_138371_((ItemLike)Items.f_42484_, Advancements.title("repair_from_broken"), Advancements.description("repair_from_broken"), null, FrameType.TASK, true, true, false).m_138386_("repair", Advancements.genericInt(GearEvents.REPAIR_FROM_BROKEN, 1)).m_138389_(consumer, Advancements.id("repair_from_broken"));
            Advancement blueprintBook = Advancements.simpleGetItem(consumer, ModItems.BLUEPRINT_BOOK, blueprintPaper);
            Advancement tipUpgrade = Advancements.simpleGetItem(consumer, ModItems.TIP, ((CompoundPartItem)ModItems.TIP.get()).create(LazyMaterialInstance.of(Const.Materials.EXAMPLE)), upgradeBase, "tip_upgrade");
            Advancement mixedMaterials = Advancement.Builder.m_138353_().m_138398_(blueprintPaper).m_138371_((ItemLike)Items.f_42616_, Advancements.title("mixed_materials"), Advancements.description("mixed_materials"), null, FrameType.TASK, true, true, false).m_138386_("mixed_materials", Advancements.genericInt(GearEvents.UNIQUE_MAIN_PARTS, 2)).m_138389_(consumer, Advancements.id("mixed_materials"));
            Advancement armor = Advancement.Builder.m_138353_().m_138398_(blueprintPaper).m_138371_(ModItems.HELMET, Advancements.title("armor"), Advancements.description("armor"), null, FrameType.TASK, true, true, false).m_138386_("helmet", Advancements.getItem(new ItemLike[]{ModItems.HELMET})).m_138386_("chestplate", Advancements.getItem(new ItemLike[]{ModItems.CHESTPLATE})).m_138386_("leggings", Advancements.getItem(new ItemLike[]{ModItems.LEGGINGS})).m_138386_("boots", Advancements.getItem(new ItemLike[]{ModItems.BOOTS})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, Advancements.id("armor"));
            Advancement bow = Advancement.Builder.m_138353_().m_138398_(blueprintPaper).m_138371_(ModItems.BOW, Advancements.title("bow"), Advancements.description("bow"), null, FrameType.TASK, true, true, false).m_138386_("get_item", Advancements.getItem(new ItemLike[]{ModItems.BOW})).m_138389_(consumer, Advancements.id("bow"));
            Advancement standardTools = Advancement.Builder.m_138353_().m_138398_(blueprintPaper).m_138371_(ModItems.PICKAXE, Advancements.title("standard_tools"), Advancements.description("standard_tools"), null, FrameType.TASK, true, true, false).m_138386_("pickaxe", Advancements.getItem(new ItemLike[]{ModItems.PICKAXE})).m_138386_("shovel", Advancements.getItem(new ItemLike[]{ModItems.SHOVEL})).m_138386_("axe", Advancements.getItem(new ItemLike[]{ModItems.AXE})).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, Advancements.id("standard_tools"));
            Advancement swords = Advancement.Builder.m_138353_().m_138398_(blueprintPaper).m_138371_(ModItems.SWORD, Advancements.title("swords"), Advancements.description("swords"), null, FrameType.TASK, true, true, false).m_138386_("sword", Advancements.getItem(new ItemLike[]{ModItems.SWORD})).m_138386_("katana", Advancements.getItem(new ItemLike[]{ModItems.KATANA})).m_138386_("machete", Advancements.getItem(new ItemLike[]{ModItems.MACHETE})).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, Advancements.id("swords"));
            Advancement bigJobTools = Advancement.Builder.m_138353_().m_138398_(standardTools).m_138371_(ModItems.HAMMER, Advancements.title("big_job_tools"), Advancements.description("big_job_tools"), null, FrameType.TASK, true, true, false).m_138386_("hammer", Advancements.getItem(new ItemLike[]{ModItems.HAMMER})).m_138386_("excavator", Advancements.getItem(new ItemLike[]{ModItems.EXCAVATOR})).m_138386_("lumber_axe", Advancements.getItem(new ItemLike[]{ModItems.SAW})).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, Advancements.id("big_job_tools"));
            Advancement crossbow = Advancements.simpleGetItem(consumer, ModItems.CROSSBOW, bow);
            Advancement mattock = Advancements.simpleGetItem(consumer, ModItems.MATTOCK, standardTools);
            Advancement sickle = Advancements.simpleGetItem(consumer, ModItems.SICKLE, mattock);
            Advancement nether = Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)Items.f_41999_, Advancements.title("nether"), Advancements.description("nether"), null, FrameType.TASK, false, false, false).m_138386_("entered_nether", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_((ResourceKey)Level.f_46429_)).m_138389_(consumer, Advancements.id("nether"));
            Advancement netherPlants = Advancement.Builder.m_138353_().m_138398_(nether).m_138371_(ModItems.NETHER_BANANA, Advancements.title("nether_plants"), Advancements.description("nether_plants"), null, FrameType.TASK, true, true, false).m_138386_("banana", Advancements.getItem(new ItemLike[]{ModItems.NETHER_BANANA})).m_138386_("sapling", Advancements.getItem(new ItemLike[]{ModBlocks.NETHERWOOD_SAPLING})).m_138360_(RequirementsStrategy.f_15978_).m_138389_(consumer, Advancements.id("nether_plants"));
            Advancement blazeGold = Advancements.simpleGetItem(consumer, CraftingItems.BLAZE_GOLD_INGOT, nether, "blaze_gold");
            Advancement crimsonIron = Advancement.Builder.m_138353_().m_138398_(nether).m_138371_((ItemLike)CraftingItems.CRIMSON_IRON_INGOT, Advancements.title("crimson_iron"), Advancements.description("crimson_iron"), null, FrameType.TASK, true, true, false).m_138386_("get_ore", Advancements.getItem(new ItemLike[]{ModBlocks.CRIMSON_IRON_ORE})).m_138386_("get_ingot", Advancements.getItem(CraftingItems.CRIMSON_IRON_INGOT)).m_138389_(consumer, Advancements.id("crimson_iron"));
            Advancement materialGrader = Advancement.Builder.m_138353_().m_138398_(blazeGold).m_138371_(ModBlocks.MATERIAL_GRADER, Advancements.title("material_grader"), Advancements.description("material_grader"), null, FrameType.TASK, true, true, false).m_138386_("get_grader", Advancements.getItem(new ItemLike[]{ModBlocks.MATERIAL_GRADER})).m_138386_("get_catalyst", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_1)).m_138389_(consumer, Advancements.id("material_grader"));
            Advancement crimsonSteel = Advancements.simpleGetItem(consumer, CraftingItems.CRIMSON_STEEL_INGOT, crimsonIron, "crimson_steel");
            Advancement salvager = Advancements.simpleGetItem(consumer, ModBlocks.SALVAGER, crimsonIron);
            Advancement highDurability = Advancement.Builder.m_138353_().m_138398_(materialGrader).m_138362_(((CompoundPartItem)ModItems.TIP.get()).create(LazyMaterialInstance.of(Const.Materials.EMERALD)), Advancements.title("high_durability"), Advancements.description("high_durability"), null, FrameType.TASK, true, true, false).m_138386_("durability", Advancements.genericInt(GearEvents.MAX_DURABILITY, 16000)).m_138389_(consumer, Advancements.id("high_durability"));
            Advancement graderCatalyst2 = Advancement.Builder.m_138353_().m_138398_(materialGrader).m_138371_((ItemLike)CraftingItems.BLAZING_DUST, Advancements.title("grader_catalyst_2"), Advancements.description("grader_catalyst_2"), null, FrameType.TASK, true, true, false).m_138386_("get_item", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_2)).m_138389_(consumer, Advancements.id("grader_catalyst_2"));
            Advancement graderCatalyst3 = Advancement.Builder.m_138353_().m_138398_(graderCatalyst2).m_138371_((ItemLike)CraftingItems.GLITTERY_DUST, Advancements.title("grader_catalyst_3"), Advancements.description("grader_catalyst_3"), null, FrameType.TASK, true, true, false).m_138386_("get_item", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_3)).m_138389_(consumer, Advancements.id("grader_catalyst_3"));
            Advancement theEnd = Advancement.Builder.m_138353_().m_138398_(nether).m_138371_((ItemLike)Items.f_42102_, Advancements.title("the_end"), Advancements.description("the_end"), null, FrameType.TASK, false, false, false).m_138386_("entered_the_end", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_((ResourceKey)Level.f_46430_)).m_138389_(consumer, Advancements.id("the_end"));
            Advancement azureSilver = Advancement.Builder.m_138353_().m_138398_(theEnd).m_138371_((ItemLike)CraftingItems.AZURE_SILVER_INGOT, Advancements.title("azure_silver"), Advancements.description("azure_silver"), null, FrameType.TASK, true, true, false).m_138386_("get_ore", Advancements.getItem(new ItemLike[]{ModBlocks.AZURE_SILVER_ORE})).m_138386_("get_ingot", Advancements.getItem(CraftingItems.AZURE_SILVER_INGOT)).m_138389_(consumer, Advancements.id("azure_silver"));
            Advancement azureElectrum = Advancement.Builder.m_138353_().m_138398_(azureSilver).m_138371_((ItemLike)CraftingItems.AZURE_ELECTRUM_INGOT, Advancements.title("azure_electrum"), Advancements.description("azure_electrum"), null, FrameType.TASK, true, true, false).m_138386_("get_ingot", Advancements.getItem(CraftingItems.AZURE_ELECTRUM_INGOT)).m_138389_(consumer, Advancements.id("azure_electrum"));
            ItemStack azureSilverBoots = new ItemStack(ModItems.BOOTS);
            GearData.writeConstructionParts(azureSilverBoots, Collections.singleton(LazyPartData.of(Const.Parts.ARMOR_BODY, (CompoundPartItem)ModItems.BOOT_PLATES.get(), LazyMaterialInstance.of(Const.Materials.AZURE_SILVER))));
            Advancement moonwalker = Advancement.Builder.m_138353_().m_138398_(azureSilver).m_138362_(azureSilverBoots, Advancements.title("moonwalker"), Advancements.description("moonwalker"), null, FrameType.TASK, true, true, false).m_138386_("fall_with_moonwalker_boots", Advancements.genericInt(GearEvents.FALL_WITH_MOONWALKER, 1)).m_138389_(consumer, Advancements.id("moonwalker"));
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, ItemLike item, Advancement parent) {
            return Advancements.simpleGetItem(consumer, item, parent, NameUtils.fromItem((ItemLike)item).m_135815_());
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, ItemLike item, Advancement parent, String key) {
            return Advancements.simpleGetItem(consumer, item, new ItemStack(item), parent, key);
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, ItemLike item, ItemStack icon, Advancement parent, String key) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138362_(icon, Advancements.title(key), Advancements.description(key), null, FrameType.TASK, true, true, false).m_138386_("get_item", Advancements.getItem(item)).m_138389_(consumer, Advancements.id(key));
        }

        private static String id(String path) {
            return SilentGear.getId(path).toString();
        }

        private static CriterionTriggerInstance getItem(ItemLike ... items) {
            return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items);
        }

        private static CriterionTriggerInstance getItem(TagKey<Item> tag) {
            return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)});
        }

        private static CriterionTriggerInstance genericInt(ResourceLocation id, int value) {
            return GenericIntTrigger.Instance.instance((ResourceLocation)id, (int)value);
        }

        private static Component title(String key) {
            return new TranslatableComponent("advancements.silentgear." + key + ".title");
        }

        private static Component description(String key) {
            return new TranslatableComponent("advancements.silentgear." + key + ".description");
        }
    }
}

