/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.EnumUtils;

public final class PartMaterialIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType partType;
    private final GearType gearType;
    private final int minTier;
    private final int maxTier;
    private MaterialGrade minGrade = MaterialGrade.NONE;
    private MaterialGrade maxGrade = MaterialGrade.NONE;
    @Nullable
    private DataResource<IMaterial> material;
    private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();

    private PartMaterialIngredient(PartType partType, GearType gearType, int minTier, int maxTier) {
        super(Stream.of(new Ingredient.Value[0]));
        this.partType = partType;
        this.gearType = gearType;
        this.minTier = minTier;
        this.maxTier = maxTier;
    }

    public static PartMaterialIngredient of(PartType partType) {
        return PartMaterialIngredient.of(partType, GearType.TOOL);
    }

    public static PartMaterialIngredient of(PartType partType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, GearType.TOOL, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType) {
        return new PartMaterialIngredient(partType, gearType, 0, Integer.MAX_VALUE);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, gearType, 0, Integer.MAX_VALUE, categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier) {
        return new PartMaterialIngredient(partType, gearType, minTier, maxTier);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, int minTier, int maxTier, IMaterialCategory ... categories) {
        PartMaterialIngredient ret = new PartMaterialIngredient(partType, gearType, minTier, maxTier);
        ret.categories.addAll(Arrays.asList(categories));
        return ret;
    }

    public static Builder builder(PartType partType) {
        return PartMaterialIngredient.builder(partType, GearType.TOOL);
    }

    public static Builder builder(PartType partType, GearType gearType) {
        return new Builder(partType, gearType);
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<Component> getJeiHint() {
        MutableComponent text;
        if (!this.categories.isEmpty()) {
            MutableComponent cats = TextUtil.separatedList(this.categories.stream().map(IMaterialCategory::getDisplayName).collect(Collectors.toList()));
            text = TextUtil.withColor(cats, Color.INDIANRED);
        } else {
            MutableComponent any = TextUtil.translate("material.category", "any");
            text = TextUtil.withColor(any, Color.LIGHTGREEN);
        }
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        text.m_7220_((Component)TextUtil.misc("spaceBrackets", key.getDisplayName()).m_130940_(ChatFormatting.GRAY));
        return Optional.of(TextUtil.translate("jei", "materialType", text));
    }

    public Set<IMaterialCategory> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        MaterialInstance mat = MaterialInstance.from(stack);
        if (mat == null) {
            return false;
        }
        return !(!mat.get().isCraftingAllowed(mat, this.partType, this.gearType) || !this.categories.isEmpty() && !mat.hasAnyCategory(this.categories) || this.material != null && !this.material.getId().equals((Object)mat.getId()) || !this.tierMatches(mat.getTier(this.partType)) || !this.gradesMatch(MaterialGrade.fromStack(stack)));
    }

    private boolean tierMatches(int tier) {
        return tier >= this.minTier && tier <= this.maxTier;
    }

    private boolean gradesMatch(MaterialGrade grade) {
        return grade.ordinal() >= this.minGrade.ordinal() && (this.maxGrade == MaterialGrade.NONE || grade.ordinal() <= this.maxGrade.ordinal());
    }

    public ItemStack[] m_43908_() {
        List<IMaterial> materials = MaterialManager.getValues();
        if (!materials.isEmpty()) {
            return (ItemStack[])materials.stream().map(MaterialInstance::of).filter(mat -> mat.get().isCraftingAllowed(mat, this.partType, this.gearType)).filter(mat -> this.material == null || this.material.getId().equals((Object)mat.getId())).filter(mat -> this.categories.isEmpty() || mat.hasAnyCategory(this.categories)).filter(mat -> this.tierMatches(mat.getTier(this.partType))).flatMap(mat -> Stream.of(mat.get().getIngredient().m_43908_())).filter(stack -> !stack.m_41619_()).map(stack -> this.minGrade != MaterialGrade.NONE ? this.minGrade.copyWithGrade((ItemStack)stack) : stack).toArray(ItemStack[]::new);
        }
        return super.m_43908_();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.partType.getName().toString());
        if (this.gearType != GearType.TOOL) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        if (this.material != null) {
            json.addProperty("material", this.material.getId().toString());
        }
        if (!this.categories.isEmpty()) {
            JsonArray array = new JsonArray();
            this.categories.forEach(cat -> array.add(cat.getName()));
            json.add("categories", (JsonElement)array);
        }
        if (this.minTier > 0) {
            json.addProperty("min_tier", (Number)this.minTier);
        }
        if (this.maxTier < Integer.MAX_VALUE) {
            json.addProperty("max_tier", (Number)this.maxTier);
        }
        if (this.minGrade != MaterialGrade.NONE) {
            json.addProperty("min_grade", this.minGrade.name());
        }
        if (this.maxGrade != MaterialGrade.NONE) {
            json.addProperty("max_grade", this.maxGrade.name());
        }
        return json;
    }

    public static class Builder {
        private final PartType partType;
        private final GearType gearType;
        private int minTier = 0;
        private int maxTier = Integer.MAX_VALUE;
        private MaterialGrade minGrade = MaterialGrade.NONE;
        private MaterialGrade maxGrade = MaterialGrade.NONE;
        private DataResource<IMaterial> material;
        private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();

        public Builder(PartType partType, GearType gearType) {
            this.partType = partType;
            this.gearType = gearType;
        }

        public Builder withCategories(IMaterialCategory ... categories) {
            this.categories.addAll(Arrays.asList(categories));
            return this;
        }

        public Builder withTier(int min, int max) {
            this.minTier = min;
            this.maxTier = max;
            return this;
        }

        public Builder withGrade(@Nullable MaterialGrade min, @Nullable MaterialGrade max) {
            if (min != null) {
                this.minGrade = min;
            }
            if (max != null) {
                this.maxGrade = max;
            }
            return this;
        }

        public Builder withMaterial(DataResource<IMaterial> material) {
            this.material = material;
            return this;
        }

        public PartMaterialIngredient build() {
            PartMaterialIngredient ret = new PartMaterialIngredient(this.partType, this.gearType, this.minTier, this.maxTier);
            ret.categories.addAll(this.categories);
            ret.minGrade = this.minGrade;
            ret.maxGrade = this.maxGrade;
            ret.material = this.material;
            return ret;
        }
    }

    public static final class Serializer
    implements IIngredientSerializer<PartMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("material");

        private Serializer() {
        }

        public PartMaterialIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation typeName = buffer.m_130281_();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.m_130277_());
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            int categoryCount = buffer.readByte();
            IMaterialCategory[] categories = new IMaterialCategory[categoryCount];
            for (int i = 0; i < categoryCount; ++i) {
                categories[i] = MaterialCategories.get(buffer.m_130277_());
            }
            int minTier = buffer.m_130242_();
            int maxTier = buffer.m_130242_();
            MaterialGrade minGrade = (MaterialGrade)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)MaterialGrade.NONE);
            MaterialGrade maxGrade = (MaterialGrade)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)MaterialGrade.NONE);
            DataResource<IMaterial> material = buffer.readBoolean() ? DataResource.material(buffer.m_130281_()) : null;
            PartMaterialIngredient ret = PartMaterialIngredient.of(partType, gearType, minTier, maxTier, categories);
            ret.minGrade = minGrade;
            ret.maxGrade = maxGrade;
            ret.material = material;
            return ret;
        }

        public PartMaterialIngredient parse(JsonObject json) {
            String typeName = GsonHelper.m_13851_((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = GsonHelper.m_13851_((JsonObject)json, (String)"gear_type", (String)"tool");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            ArrayList<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
            if (json.has("categories")) {
                JsonArray array = json.getAsJsonArray("categories");
                for (JsonElement element : array) {
                    categories.add(MaterialCategories.get(element.getAsString()));
                }
            }
            int minTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)0);
            int maxTier = GsonHelper.m_13824_((JsonObject)json, (String)"max_tier", (int)Integer.MAX_VALUE);
            MaterialGrade minGrade = MaterialGrade.fromString(GsonHelper.m_13851_((JsonObject)json, (String)"min_grade", (String)"NONE"));
            MaterialGrade maxGrade = MaterialGrade.fromString(GsonHelper.m_13851_((JsonObject)json, (String)"max_grade", (String)"NONE"));
            DataResource<IMaterial> material = json.has("material") ? DataResource.material(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"material"))) : null;
            PartMaterialIngredient ret = PartMaterialIngredient.of(type, gearType, minTier, maxTier);
            ret.categories.addAll(categories);
            ret.minGrade = minGrade;
            ret.maxGrade = maxGrade;
            ret.material = material;
            return ret;
        }

        public void write(FriendlyByteBuf buffer, PartMaterialIngredient ingredient) {
            buffer.m_130085_(ingredient.partType.getName());
            buffer.m_130070_(ingredient.gearType.getName());
            buffer.writeByte(ingredient.categories.size());
            ingredient.categories.forEach(cat -> buffer.m_130070_(cat.getName()));
            buffer.m_130130_(ingredient.minTier);
            buffer.m_130130_(ingredient.maxTier);
            buffer.writeByte(ingredient.minGrade.ordinal());
            buffer.writeByte(ingredient.maxGrade.ordinal());
            buffer.writeBoolean(ingredient.material != null);
            if (ingredient.material != null) {
                buffer.m_130085_(ingredient.material.getId());
            }
        }
    }
}

