/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.Size2i;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.gear.util.TextUtil;

public class GearCraftingRecipeCategoryJei
implements IRecipeCategory<CraftingRecipe> {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 132;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public GearCraftingRecipeCategoryJei(IGuiHelper guiHelper) {
        ModResourceLocation location = SilentGear.getId("textures/gui/gear_crafting_jei.png");
        this.background = guiHelper.createDrawable((ResourceLocation)location, 0, 0, 160, 132);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModItems.BLUEPRINT_PACKAGE));
        this.localizedName = TextUtil.translate("gui", "category.gearCrafting");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    public ResourceLocation getUid() {
        return SGearJeiPlugin.GEAR_CRAFTING;
    }

    public Class<? extends CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ArrayList<List<ItemStack>> shiftedInputs = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < inputs.size(); ++i) {
            shiftedInputs.add(GearCraftingRecipeCategoryJei.shiftIngredients((List)inputs.get(i), 5 * i));
        }
        Size2i size = GearCraftingRecipeCategoryJei.getRecipeSize(recipe);
        if (size != null && size.width > 0 && size.height > 0) {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, shiftedInputs, size.width, size.height);
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, shiftedInputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    private static List<ItemStack> shiftIngredients(List<ItemStack> list, int amount) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(list);
        if (ret.isEmpty() || !((Boolean)Config.Common.allowLegacyMaterialMixing.get()).booleanValue()) {
            return ret;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = (ItemStack)ret.get(ret.size() - 1);
            ret.remove(ret.size() - 1);
            ret.add(0, stack);
        }
        return ret;
    }

    public void setIngredients(CraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        ingredients.setInputIngredients((List)recipe.m_7527_());
    }

    @Nullable
    private static Size2i getRecipeSize(CraftingRecipe recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return new Size2i(shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight());
        }
        return null;
    }

    public void draw(CraftingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        NonNullList ingredients = recipe.m_7527_();
        for (int i = 0; i < ingredients.size(); ++i) {
            Component text;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (!(ingredient instanceof IGearIngredient) || (text = (Component)((IGearIngredient)ingredient).getJeiHint().orElse(null)) == null) continue;
            String prefix = i + 1 + ": ";
            lines.add(new TextComponent(prefix).m_7220_(text));
        }
        matrixStack.m_85836_();
        float scale = lines.size() > 5 ? 0.75f : 1.0f;
        matrixStack.m_85841_(scale, scale, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        int y = (int)(56.0f / scale);
        for (Component component : lines) {
            font.m_92744_(matrixStack, component.m_7532_(), 0.0f, (float)y, -1);
            y += 10;
        }
        matrixStack.m_85849_();
    }
}

