/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.lib.util.PlayerUtils;

public final class RandomGearCommand {
    private static final SuggestionProvider<CommandSourceStack> itemIdSuggestions = (context, builder) -> SharedSuggestionProvider.m_82957_(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ICoreItem).map(ForgeRegistryEntry::getRegistryName), (SuggestionsBuilder)builder);

    private RandomGearCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgear_random_gear").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(itemIdSuggestions).executes(context -> RandomGearCommand.run((CommandContext<CommandSourceStack>)context, EntityArgument.m_91477_((CommandContext)context, (String)"players"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"item"), 3))).then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RandomGearCommand.run((CommandContext<CommandSourceStack>)context, EntityArgument.m_91477_((CommandContext)context, (String)"players"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))))));
    }

    private static int run(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, ResourceLocation itemId, int tier) throws CommandSyntaxException {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (!(item instanceof ICoreItem)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TranslatableComponent("command.silentgear.randomGear.invalidItem"));
            return 0;
        }
        for (ServerPlayer player : players) {
            ItemStack stack = GearGenerator.create((ICoreItem)item, tier);
            if (stack.m_41619_()) continue;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, stack.m_41611_(), player.m_5446_()}), true);
            PlayerUtils.giveItem((Player)player, (ItemStack)stack.m_41777_());
        }
        return 1;
    }
}

