/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.CompoundPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.utils.Color;

@OnlyIn(value=Dist.CLIENT)
public final class GearClientHelper {
    private GearClientHelper() {
    }

    public static int getColor(ItemStack stack, PartType layer) {
        PartData part = GearData.getPartOfType(stack, layer);
        if (part != null) {
            return part.getColor(stack, 0, 0);
        }
        return 0xFFFFFF;
    }

    public static void addInformation(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        GearTooltipFlag flagTC = flag instanceof GearTooltipFlag ? (GearTooltipFlag)flag : GearTooltipFlag.withModifierKeys(flag.m_7050_(), true, true);
        GearClientHelper.addInformation(stack, world, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, Level world, List<Component> tooltip, GearTooltipFlag flag) {
        PartDataList constructionParts;
        if (!(stack.m_41720_() instanceof ICoreItem)) {
            return;
        }
        ICoreItem item = (ICoreItem)stack.m_41720_();
        if (GearHelper.isBroken(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("broken", new Object[0]), Color.FIREBRICK));
        }
        if (GearData.isExampleGear(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("exampleOutput1", new Object[0]), Color.YELLOW));
            tooltip.add(Math.min(2, tooltip.size()), (Component)TextUtil.withColor(GearClientHelper.misc("exampleOutput2", new Object[0]), Color.YELLOW));
        }
        if ((constructionParts = GearData.getConstructionParts(stack)).getMains().isEmpty()) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("invalidParts", new Object[0]), Color.FIREBRICK));
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("lockedStats", new Object[0]), Color.FIREBRICK));
        } else if (GearData.hasLockedStats(stack)) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("lockedStats", new Object[0]), Color.YELLOW));
        }
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            Collections.reverse(constructionParts);
            for (PartData data : constructionParts) {
                data.get().addInformation(data, stack, tooltip, flag);
            }
        }
        GearClientHelper.addTraitsInfo(stack, tooltip, flag);
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            GearClientHelper.addStatsInfo(stack, tooltip, flag, item);
        }
        if (KeyTracker.isDisplayConstructionDown() && flag.showConstruction) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("tooltip.construction", new Object[0]), Color.GOLD));
            Collections.reverse(constructionParts);
            GearClientHelper.tooltipListParts(stack, tooltip, constructionParts, flag);
        } else if (flag.showConstruction) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.construction", new Object[0]), Color.GOLD).m_7220_((Component)new TextComponent(" ").m_7220_((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_CONSTRUCTION), ChatFormatting.GRAY))));
        }
    }

    public static void addStatsInfo(ItemStack stack, List<Component> tooltip, GearTooltipFlag flag, ICoreItem item) {
        if (KeyTracker.isDisplayStatsDown() && flag.showStats) {
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("tooltip.stats", new Object[0]), Color.GOLD));
            tooltip.add((Component)TextUtil.withColor(GearClientHelper.misc("tier", GearData.getTier(stack)), Color.DEEPSKYBLUE));
            Set<ItemStat> relevantStats = item.getRelevantStats(stack);
            Set<ItemStat> displayStats = flag.m_7050_() && SilentGear.isDevBuild() ? ItemStats.allStatsOrdered() : relevantStats;
            TextListBuilder builder = new TextListBuilder();
            for (ItemStat stat : displayStats) {
                if (stat == ItemStats.ENCHANTABILITY && !((Boolean)Config.Common.allowEnchanting.get()).booleanValue()) continue;
                float statValue = GearData.getStat(stack, stat);
                StatInstance inst = StatInstance.of(statValue, StatInstance.Operation.AVG, StatInstance.DEFAULT_KEY);
                Color nameColor = relevantStats.contains(stat) ? stat.getNameColor() : TooltipHandler.MC_DARK_GRAY;
                MutableComponent textName = TextUtil.withColor(stat.getDisplayName(), nameColor);
                MutableComponent textStat = inst.getFormattedText(stat, stat.isDisplayAsInt() ? 0 : 2, false);
                if (stat == ItemStats.DURABILITY) {
                    int durabilityLeft = stack.m_41776_() - stack.m_41773_();
                    int durabilityMax = stack.m_41776_();
                    textStat = GearClientHelper.statText("durabilityFormat", durabilityLeft, durabilityMax);
                } else if (stat == ItemStats.HARVEST_LEVEL) {
                    textStat = TooltipHandler.harvestLevelWithHint(textStat, statValue);
                }
                builder.add((Component)GearClientHelper.statText("displayFormat", textName, textStat));
            }
            tooltip.addAll(builder.build());
        } else if (flag.showStats) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.stats", new Object[0]), Color.GOLD).m_7220_((Component)new TextComponent(" ").m_7220_((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_STATS), ChatFormatting.GRAY))));
        }
    }

    private static void addTraitsInfo(ItemStack stack, List<Component> tooltip, GearTooltipFlag flag) {
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(stack);
        ArrayList<ITrait> visibleTraits = new ArrayList<ITrait>();
        for (ITrait t : traits.keySet()) {
            if (t == null || !t.showInTooltip(flag)) continue;
            visibleTraits.add(t);
        }
        int traitIndex = GearClientHelper.getTraitDisplayIndex(visibleTraits.size(), flag);
        MutableComponent textTraits = TextUtil.withColor(GearClientHelper.misc("tooltip.traits", new Object[0]), Color.GOLD);
        if (traitIndex < 0 && !((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            tooltip.add((Component)textTraits);
        }
        int i = 0;
        for (ITrait trait : visibleTraits) {
            if (traitIndex < 0 || traitIndex == i) {
                int level = traits.get(trait);
                trait.addInformation(level, tooltip, flag, text -> {
                    if (((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
                        return TextUtil.withColor((MutableComponent)new TextComponent("\u2666 "), Color.GRAY).m_7220_(text);
                    }
                    if (traitIndex >= 0) {
                        return textTraits.m_7220_((Component)TextUtil.withColor((MutableComponent)new TextComponent(": "), ChatFormatting.GRAY).m_7220_(text));
                    }
                    return new TextComponent(TextListBuilder.BULLETS[0] + " ").m_7220_(text);
                });
            }
            ++i;
        }
    }

    private static int getTraitDisplayIndex(int numTraits, GearTooltipFlag flag) {
        if (((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue() || KeyTracker.isDisplayTraitsDown() || numTraits == 0) {
            return -1;
        }
        return ClientTicks.ticksInGame() / 20 % numTraits;
    }

    private static MutableComponent misc(String key, Object ... formatArgs) {
        return new TranslatableComponent("misc.silentgear." + key, formatArgs);
    }

    private static MutableComponent statText(String key, Object ... formatArgs) {
        return new TranslatableComponent("stat.silentgear." + key, formatArgs);
    }

    public static void tooltipListParts(ItemStack gear, List<Component> tooltip, Collection<PartData> parts, GearTooltipFlag flag) {
        TextListBuilder builder = new TextListBuilder();
        for (PartData part : parts) {
            if (!part.get().isVisible()) continue;
            int partNameColor = Color.blend((int)part.getColor(gear), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            MutableComponent partNameText = TextUtil.withColor(part.getDisplayName(gear).m_6881_(), partNameColor);
            builder.add((Component)(flag.m_7050_() ? partNameText.m_7220_((Component)TextUtil.misc("spaceBrackets", part.getType().getName()).m_130940_(ChatFormatting.DARK_GRAY)) : partNameText));
            if (!(part.get() instanceof CompoundPart)) continue;
            builder.indent();
            for (IMaterialInstance material : CompoundPartItem.getMaterials(part.getItem())) {
                int nameColor = material.getNameColor(part.getType(), GearType.ALL);
                builder.add((Component)TextUtil.withColor(material.getDisplayNameWithModifiers(part.getType(), ItemStack.f_41583_), nameColor));
            }
            builder.unindent();
        }
        tooltip.addAll(builder.build());
    }

    public static boolean hasEffect(ItemStack stack) {
        return (Boolean)Config.Client.allowEnchantedEffect.get() != false && stack.m_41793_();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }
}

