/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.fragment;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.model.ModelErrorLogging;
import net.silentchaos512.gear.client.model.fragment.FragmentModel;
import net.silentchaos512.gear.item.FragmentItem;

public class FragmentModelOverrideList
extends ItemOverrides {
    private final Cache<CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final FragmentModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ResourceLocation modelLocation;

    public FragmentModelOverrideList(FragmentModel model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    @Nullable
    public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int p_173469_) {
        CacheKey key = FragmentModelOverrideList.getKey(model, stack, (Level)worldIn, entityIn);
        try {
            return (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, worldIn, entityIn));
        }
        catch (Exception e) {
            ModelErrorLogging.notifyOfException(e, "fragment");
            return model;
        }
    }

    private BakedModel getOverrideModel(ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn) {
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        IMaterialInstance material = FragmentItem.getMaterial(stack);
        if (material != null) {
            IMaterialDisplay model = material.getDisplayProperties();
            int layerLevel = 0;
            for (MaterialLayer layer : model.getLayerList(GearType.FRAGMENT, PartType.MAIN, material)) {
                int blendedColor = model.getLayerColor(GearType.FRAGMENT, PartType.MAIN, material, layerLevel);
                layers.add(new MaterialLayer(layer.getTextureId(), blendedColor));
                ++layerLevel;
            }
        }
        return this.model.bake(layers, this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private static CacheKey getKey(BakedModel model, ItemStack stack, @Nullable Level world, @Nullable LivingEntity entity) {
        return new CacheKey(model, FragmentItem.getModelKey(stack));
    }

    public void clearCache() {
        SilentGear.LOGGER.debug("Clearing model cache for fragments");
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final BakedModel parent;
        final String data;

        CacheKey(BakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

