/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;

public abstract class LayeredModel<T extends IModelGeometry<T>>
implements IModelGeometry<T> {
    public static List<BakedQuad> getQuadsForSprite(int tintIndex, TextureAtlasSprite sprite, Transformation transform, int color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.m_118405_();
        int vMax = sprite.m_118408_();
        for (int v = 0; v < vMax; ++v) {
            builder.add((Object)LayeredModel.buildSideQuad(transform, Direction.UP, tintIndex, color, sprite, 0, v, uMax));
            builder.add((Object)LayeredModel.buildSideQuad(transform, Direction.DOWN, tintIndex, color, sprite, 0, v + 1, uMax));
        }
        for (int u = 0; u < uMax; ++u) {
            builder.add((Object)LayeredModel.buildSideQuad(transform, Direction.EAST, tintIndex, color, sprite, u + 1, 0, vMax));
            builder.add((Object)LayeredModel.buildSideQuad(transform, Direction.WEST, tintIndex, color, sprite, u, 0, vMax));
        }
        builder.add((Object)LayeredModel.buildQuad(transform, Direction.NORTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.46875f, sprite.m_118409_(), sprite.m_118412_(), 0.0f, 1.0f, 0.46875f, sprite.m_118409_(), sprite.m_118411_(), 1.0f, 1.0f, 0.46875f, sprite.m_118410_(), sprite.m_118411_(), 1.0f, 0.0f, 0.46875f, sprite.m_118410_(), sprite.m_118412_()));
        builder.add((Object)LayeredModel.buildQuad(transform, Direction.SOUTH, sprite, tintIndex, color, 0.0f, 0.0f, 0.53125f, sprite.m_118409_(), sprite.m_118412_(), 1.0f, 0.0f, 0.53125f, sprite.m_118410_(), sprite.m_118412_(), 1.0f, 1.0f, 0.53125f, sprite.m_118410_(), sprite.m_118411_(), 0.0f, 1.0f, 0.53125f, sprite.m_118409_(), sprite.m_118411_()));
        return builder.build();
    }

    private static BakedQuad buildSideQuad(Transformation transform, Direction side, int tintIndex, int color, TextureAtlasSprite sprite, int u, int v, int size) {
        int width = sprite.m_118405_();
        int height = sprite.m_118408_();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
                x1 = (float)(u + size) / (float)width;
                break;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float eps = 0.01f;
        float dx = (float)side.m_122436_().m_123341_() * 0.01f / (float)width;
        float dy = (float)side.m_122436_().m_123342_() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return LayeredModel.buildQuad(transform, LayeredModel.remap(side), sprite, tintIndex, color, x0, y0, z0, sprite.m_118367_((double)u0), sprite.m_118393_((double)v0), x1, y1, z0, sprite.m_118367_((double)u1), sprite.m_118393_((double)v1), x1, y1, z1, sprite.m_118367_((double)u1), sprite.m_118393_((double)v1), x0, y0, z1, sprite.m_118367_((double)u0), sprite.m_118393_((double)v0));
    }

    private static Direction remap(Direction side) {
        return side.m_122434_() == Direction.Axis.Y ? side.m_122424_() : side;
    }

    private static BakedQuad buildQuad(Transformation transform, Direction side, TextureAtlasSprite sprite, int tintIndex, int color, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tintIndex);
        builder.setQuadOrientation(side);
        boolean hasTransform = !transform.isIdentity();
        BakedQuadBuilder consumer = hasTransform ? new TRSRTransformer((IVertexConsumer)builder, transform) : builder;
        LayeredModel.putVertex((IVertexConsumer)consumer, side, x0, y0, z0, u0, v0, color);
        LayeredModel.putVertex((IVertexConsumer)consumer, side, x1, y1, z1, u1, v1, color);
        LayeredModel.putVertex((IVertexConsumer)consumer, side, x2, y2, z2, u2, v2, color);
        LayeredModel.putVertex((IVertexConsumer)consumer, side, x3, y3, z3, u3, v3, color);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, Direction side, float x, float y, float z, float u, float v, int color) {
        VertexFormat format = consumer.getVertexFormat();
        block6: for (int e = 0; e < format.m_86023_().size(); ++e) {
            switch (((VertexFormatElement)format.m_86023_().get(e)).m_86048_()) {
                case POSITION: {
                    consumer.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    a = a == 0.0f ? 1.0f : a;
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    consumer.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case NORMAL: {
                    float offX = side.m_122429_();
                    float offY = side.m_122430_();
                    float offZ = side.m_122431_();
                    consumer.put(e, new float[]{offX, offY, offZ, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)format.m_86023_().get(e)).m_86049_() == 0) {
                        consumer.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

