/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.EvenSplitItemStat;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.utils.Color;

public final class ItemStats {
    static final List<ItemStat> STATS_IN_ORDER = new ArrayList<ItemStat>();
    private static Supplier<IForgeRegistry<ItemStat>> REGISTRY;
    public static final ItemStat DURABILITY;
    public static final ItemStat ARMOR_DURABILITY;
    public static final ItemStat REPAIR_EFFICIENCY;
    public static final ItemStat REPAIR_VALUE;
    public static final ItemStat ENCHANTABILITY;
    public static final ItemStat CHARGEABILITY;
    public static final ItemStat RARITY;
    public static final ItemStat HARVEST_LEVEL;
    public static final ItemStat HARVEST_SPEED;
    public static final ItemStat REACH_DISTANCE;
    public static final ItemStat MELEE_DAMAGE;
    public static final ItemStat MAGIC_DAMAGE;
    public static final ItemStat ATTACK_SPEED;
    public static final ItemStat ATTACK_REACH;
    public static final ItemStat RANGED_DAMAGE;
    public static final ItemStat RANGED_SPEED;
    public static final ItemStat PROJECTILE_SPEED;
    public static final ItemStat PROJECTILE_ACCURACY;
    public static final ItemStat ARMOR;
    public static final ItemStat ARMOR_TOUGHNESS;
    public static final ItemStat KNOCKBACK_RESISTANCE;
    public static final ItemStat MAGIC_ARMOR;

    public static IForgeRegistry<ItemStat> getRegistry() {
        return REGISTRY.get();
    }

    private ItemStats() {
    }

    public static Collection<ItemStat> allStatsOrdered() {
        return Collections.unmodifiableList(STATS_IN_ORDER);
    }

    public static Collection<ItemStat> allStatsOrderedExcluding(Collection<ItemStat> exclude) {
        ArrayList<ItemStat> ret = new ArrayList<ItemStat>(STATS_IN_ORDER);
        ret.removeIf(exclude::contains);
        return ret;
    }

    @Nullable
    public static ItemStat byName(String name) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(name);
        return id != null ? (ItemStat)ItemStats.getRegistry().getValue(id) : null;
    }

    @Nullable
    public static ItemStat byName(ResourceLocation id) {
        return (ItemStat)ItemStats.getRegistry().getValue(id);
    }

    @Nullable
    public static ItemStat get(IItemStat stat) {
        return (ItemStat)ItemStats.getRegistry().getValue(stat.getStatId());
    }

    public static void createRegistry(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder().setType(ItemStat.class).setName((ResourceLocation)SilentGear.getId("stat")));
    }

    public static void registerStats(RegistryEvent.Register<ItemStat> event) {
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), DURABILITY, "durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_DURABILITY, "armor_durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REPAIR_EFFICIENCY, "repair_efficiency");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REPAIR_VALUE, "repair_value");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ENCHANTABILITY, "enchantability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), CHARGEABILITY, "chargeability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RARITY, "rarity");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_LEVEL, "harvest_level");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_SPEED, "harvest_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REACH_DISTANCE, "reach_distance");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MELEE_DAMAGE, "melee_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_DAMAGE, "magic_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ATTACK_SPEED, "attack_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ATTACK_REACH, "attack_reach");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_DAMAGE, "ranged_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_SPEED, "ranged_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), PROJECTILE_ACCURACY, "projectile_accuracy");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), PROJECTILE_SPEED, "projectile_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR, "armor");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_TOUGHNESS, "armor_toughness");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), KNOCKBACK_RESISTANCE, "knockback_resistance");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_ARMOR, "magic_armor");
    }

    private static void register(IForgeRegistry<ItemStat> registry, ItemStat stat, String name) {
        registry.register((IForgeRegistryEntry)((ItemStat)stat.setRegistryName(SilentGear.getId(name))));
    }

    static {
        DURABILITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
        ARMOR_DURABILITY = new ItemStat(0.0f, 0.0f, 1.3421773E8f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies());
        REPAIR_EFFICIENCY = new ItemStat(1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
        REPAIR_VALUE = new ItemStat(1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
        ENCHANTABILITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
        CHARGEABILITY = new ItemStat(1.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().affectedByGrades(false));
        RARITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(false));
        HARVEST_LEVEL = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().defaultOp(StatInstance.Operation.MAX).displayAsInt().affectedByGrades(false));
        HARVEST_SPEED = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
        REACH_DISTANCE = new ItemStat(0.0f, -100.0f, 100.0f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(false));
        MELEE_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
        MAGIC_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies().hidden());
        ATTACK_SPEED = new ItemStat(0.0f, -3.9f, 4.0f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(false));
        ATTACK_REACH = new ItemStat(3.0f, 0.0f, 100.0f, Color.SANDYBROWN, new ItemStat.Properties().baseValue(3.0f).affectedByGrades(false));
        RANGED_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies());
        RANGED_SPEED = new ItemStat(0.0f, -10.0f, 10.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false));
        PROJECTILE_SPEED = new ItemStat(1.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false).synergyApplies());
        PROJECTILE_ACCURACY = new ItemStat(1.0f, 0.0f, 10000.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
        ARMOR = new SplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, (Map<GearType, Float>)ImmutableMap.of((Object)GearType.HELMET, (Object)Float.valueOf(3.0f), (Object)GearType.CHESTPLATE, (Object)Float.valueOf(8.0f), (Object)GearType.LEGGINGS, (Object)Float.valueOf(6.0f), (Object)GearType.BOOTS, (Object)Float.valueOf(3.0f)), new ItemStat.Properties().affectedByGrades(true).synergyApplies());
        ARMOR_TOUGHNESS = new EvenSplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
        KNOCKBACK_RESISTANCE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
        MAGIC_ARMOR = new EvenSplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    }
}

