/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.utils.EnumUtils;

public enum MaterialGrade {
    NONE(0),
    E(1),
    D(2),
    C(3),
    B(4),
    A(5),
    S(10),
    SS(15),
    SSS(25),
    MAX(30);

    private static final String NBT_KEY = "SGear_Grade";
    public final int bonusPercent;

    private MaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static MaterialGrade getMax() {
        return MaterialGrade.values()[MaterialGrade.values().length - 1];
    }

    public static MaterialGrade fromStack(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_(NBT_KEY)) {
            String str = stack.m_41784_().m_128461_(NBT_KEY);
            return MaterialGrade.fromString(str);
        }
        return NONE;
    }

    public static MaterialGrade fromString(String str) {
        if (!str.isEmpty()) {
            for (MaterialGrade grade : MaterialGrade.values()) {
                if (!grade.name().equalsIgnoreCase(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    public static MaterialGrade selectWithCatalyst(Random random, @Nonnegative int catalystTier) {
        int ordinal = ((MaterialGrade)((Object)Config.Common.graderMedianGrade.get())).ordinal() + catalystTier - 1;
        MaterialGrade median = (MaterialGrade)EnumUtils.byOrdinal((int)ordinal, (Enum)MaterialGrade.getMax());
        return MaterialGrade.selectRandom(random, median, (Double)Config.Common.graderStandardDeviation.get(), MaterialGrade.getMax());
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade median, double stdDev, MaterialGrade maxGrade) {
        int val = (int)Math.round(stdDev * random.nextGaussian() + (double)median.ordinal());
        val = Mth.m_14045_((int)val, (int)1, (int)maxGrade.ordinal());
        return MaterialGrade.values()[val];
    }

    public void setGradeOnStack(@Nonnull ItemStack stack) {
        if (!stack.m_41619_()) {
            if (this != NONE) {
                stack.m_41784_().m_128359_(NBT_KEY, this.name());
            } else {
                stack.m_41784_().m_128473_(NBT_KEY);
            }
        }
    }

    public ItemStack copyWithGrade(@Nonnull ItemStack stack) {
        ItemStack ret = stack.m_41777_();
        this.setGradeOnStack(ret);
        return ret;
    }

    public MutableComponent getDisplayName() {
        return new TranslatableComponent("stat.silentgear.grade." + this.name());
    }

    public static class Range {
        public static final Range OPEN = new Range(NONE, MaterialGrade.getMax());
        private final MaterialGrade min;
        private final MaterialGrade max;

        public Range(MaterialGrade min, MaterialGrade max) {
            this.min = min;
            this.max = max;
            if (this.min.ordinal() > this.max.ordinal()) {
                throw new IllegalArgumentException("min grade is greater than max grade");
            }
        }

        public boolean test(MaterialGrade grade) {
            int o = grade.ordinal();
            return o >= this.min.ordinal() && o <= this.max.ordinal();
        }

        public static Range deserialize(JsonElement json) {
            if (json.isJsonPrimitive()) {
                MaterialGrade grade = MaterialGrade.fromString(json.getAsString());
                return grade != NONE ? new Range(grade, grade) : OPEN;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            String min = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"min", (String)"NONE");
            String max = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"max", (String)"MAX");
            return new Range(MaterialGrade.fromString(min), MaterialGrade.fromString(max));
        }
    }
}

