/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.ModelPropertiesHelper;

public interface ICoreRangedWeapon
extends ICoreTool {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ENCHANTABILITY, (Object)ItemStats.RANGED_DAMAGE, (Object)ItemStats.RANGED_SPEED);
    public static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.ARMOR_DURABILITY, (Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.REACH_DISTANCE, (Object)ItemStats.MELEE_DAMAGE, (Object[])new ItemStat[]{ItemStats.ARMOR, ItemStats.ARMOR_TOUGHNESS, ItemStats.MAGIC_ARMOR, ItemStats.KNOCKBACK_RESISTANCE});

    @Override
    default public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    default public Collection<PartType> getRequiredParts() {
        return ImmutableList.of((Object)PartType.MAIN, (Object)PartType.ROD, (Object)PartType.CORD);
    }

    @Override
    default public int getAnimationFrames() {
        return 4;
    }

    @Override
    default public int getAnimationFrame(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        ItemPropertyFunction pullProperty;
        float pulling;
        ItemPropertyFunction pullingProperty = ModelPropertiesHelper.get(stack, new ResourceLocation("pulling"));
        if (pullingProperty != null && (pulling = pullingProperty.m_141951_(stack, world, entity, 0)) > 0.0f && (pullProperty = ModelPropertiesHelper.get(stack, new ResourceLocation("pull"))) != null) {
            float pull = pullProperty.m_141951_(stack, world, entity, 0);
            if (pull > 0.9f) {
                return 3;
            }
            if (pull > 0.65f) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    default public float getBaseDrawDelay(ItemStack stack) {
        return 20.0f;
    }

    default public float getDrawDelay(ItemStack stack) {
        float speed = this.getStat(stack, ItemStats.RANGED_SPEED);
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        return this.getBaseDrawDelay(stack) / speed;
    }

    @Override
    default public boolean hasTexturesFor(PartType partType) {
        return partType != PartType.FLETCHING && partType != PartType.ADORNMENT && partType != PartType.LINING;
    }
}

