/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import io.github.noeppi_noeppi.libx.screen.Panel;
import io.github.noeppi_noeppi.libx.util.CachedValue;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorPicker
extends Panel {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 100;
    private static final int HUE_VERTICES = 40;
    private static final int HSB_VERTICES = 20;
    private int red;
    private int green;
    private int blue;
    private float hue;
    private float saturation;
    private float brightness;
    private final CachedValue<TextColor> colorValue = new CachedValue<TextColor>(() -> TextColor.m_131266_((int)((this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF)));
    private final List<VertexInfo> huePanel = ColorPicker.createHuePanel(105, 0, 110, 100);
    private final CachedValue<List<VertexInfo>> hsbMatrix = new CachedValue<List>(() -> ColorPicker.createHsbMatrix(this.hue, 0, 0, 100, 100));
    private final ValueSlider redSlider = this.addRenderableWidget(new ValueSlider(115, 0, 85, 20, "libx.gui.color_picker.red", () -> this.red, red -> {
        this.red = red;
        this.updateHSB();
    }));
    private final ValueSlider greenSlider = this.addRenderableWidget(new ValueSlider(115, 23, 85, 20, "libx.gui.color_picker.green", () -> this.green, green -> {
        this.green = green;
        this.updateHSB();
    }));
    private final ValueSlider blueSlider = this.addRenderableWidget(new ValueSlider(115, 46, 85, 20, "libx.gui.color_picker.blue", () -> this.blue, blue -> {
        this.blue = blue;
        this.updateHSB();
    }));
    @Nullable
    private Consumer<TextColor> responder;
    private TextColor lastDelivered = null;
    private boolean enabled;

    public ColorPicker(Screen screen, int x, int y) {
        this(screen, x, y, null);
    }

    public ColorPicker(Screen screen, int x, int y, @Nullable ColorPicker old) {
        super(screen, x, y, 200, 100);
        if (old != null) {
            this.setColor(old.getColor());
        } else {
            this.update();
        }
        this.enabled = true;
    }

    public TextColor getColor() {
        return this.colorValue.get();
    }

    public void setColor(TextColor color) {
        int rgb = 0xFFFFFF & color.m_131265_();
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.updateHSB();
    }

    public void setResponder(@Nullable Consumer<TextColor> responder) {
        this.responder = responder;
        this.lastDelivered = null;
    }

    private void updateRGB() {
        int rgb = 0xFFFFFF & Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.update();
    }

    private void updateHSB() {
        float[] values = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        this.hue = values[0];
        this.saturation = values[1];
        this.brightness = values[2];
        this.update();
    }

    private void update() {
        this.colorValue.invalidate();
        this.hsbMatrix.invalidate();
        this.redSlider.update();
        this.greenSlider.update();
        this.blueSlider.update();
        if (this.responder != null && (this.lastDelivered == null || this.lastDelivered.m_131265_() != this.colorValue.get().m_131265_())) {
            this.responder.accept(this.colorValue.get());
            this.lastDelivered = this.colorValue.get();
        }
    }

    @Override
    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int colorValue;
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
        BufferBuilder vertex = Tesselator.m_85913_().m_85915_();
        vertex.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        if (this.enabled) {
            this.hsbMatrix.get().forEach(v -> v.add((VertexConsumer)vertex, matrix));
        } else {
            this.hsbMatrix.get().forEach(v -> v.addGrayscale((VertexConsumer)vertex, matrix));
        }
        vertex.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)vertex);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
        vertex = Tesselator.m_85913_().m_85915_();
        vertex.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        if (this.enabled) {
            this.huePanel.forEach(v -> v.add((VertexConsumer)vertex, matrix));
        } else {
            this.huePanel.forEach(v -> v.addGrayscale((VertexConsumer)vertex, matrix));
        }
        vertex.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)vertex);
        int displayColor = colorValue = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        if (!this.enabled) {
            int value = Math.round((float)(this.red + this.green + this.blue) / 3.0f) & 0xFF;
            displayColor = value << 16 | value << 8 | value;
        }
        int highlightColor = (double)this.brightness > 0.5 ? 0 : 0xFFFFFF;
        RenderSystem.m_157456_((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
        RenderHelper.rgb(highlightColor);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)115, (int)69, (int)20, (float)0.0f, (float)0.0f, (int)85, (int)31, (int)256, (int)256);
        RenderHelper.rgb(displayColor);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)116, (int)70, (int)40, (float)0.0f, (float)0.0f, (int)83, (int)29, (int)256, (int)256);
        String colorText = String.format("#%06X", colorValue);
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, colorText, (float)(157 - Minecraft.m_91087_().f_91062_.m_92895_(colorText) / 2), 80.0f, highlightColor);
        poseStack.m_85849_();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.updateColorValue(mouseX, mouseY, mouseX, mouseY);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.updateColorValue(mouseX, mouseY, mouseX - dragX, mouseY - dragY);
    }

    private boolean updateColorValue(double mouseX, double mouseY, double boundsX, double boundsY) {
        if (!this.enabled) {
            return false;
        }
        mouseX -= (double)this.f_93620_;
        mouseY -= (double)this.f_93621_;
        boundsX -= (double)this.f_93620_;
        boundsY -= (double)this.f_93621_;
        if (boundsX >= 0.0 && boundsX <= 100.0 && boundsY >= 0.0 && boundsY <= 100.0) {
            this.saturation = (float)(Mth.m_14008_((double)mouseX, (double)0.0, (double)100.0) / 100.0);
            this.brightness = (float)(1.0 - Mth.m_14008_((double)mouseY, (double)0.0, (double)100.0) / 100.0);
            this.updateRGB();
            this.f_93616_ = null;
            return true;
        }
        if (boundsX >= 105.0 && boundsX <= 110.0 && boundsY >= 0.0 && boundsY <= 100.0) {
            this.hue = (float)(Mth.m_14008_((double)mouseY, (double)0.0, (double)100.0) / 100.0);
            this.updateRGB();
            this.f_93616_ = null;
            return true;
        }
        return false;
    }

    @Override
    public void enabled(boolean enabled) {
        super.enabled(enabled);
        this.enabled = enabled;
    }

    private static List<VertexInfo> createHsbMatrix(float hue, int x1, int y1, int x2, int y2) {
        LinkedList<List<ColorValue>> colors = new LinkedList<List<ColorValue>>();
        for (int y = 0; y < 20; ++y) {
            float brightness = 1.0f - (float)y / 20.0f;
            LinkedList<ColorValue> row = new LinkedList<ColorValue>();
            for (int x = 0; x < 20; ++x) {
                float saturation = (float)x / 20.0f;
                row.add(ColorValue.create(Color.HSBtoRGB(hue, saturation, brightness)));
            }
            colors.add(row);
        }
        return ColorPicker.createColorMatrix(x1, y1, x2, y2, colors);
    }

    private static List<VertexInfo> createHuePanel(int x1, int y1, int x2, int y2) {
        LinkedList<List<ColorValue>> colors = new LinkedList<List<ColorValue>>();
        for (int x = 0; x < 40; ++x) {
            float hue = (float)x / 40.0f;
            ColorValue color = ColorValue.create(Color.HSBtoRGB(hue, 1.0f, 1.0f));
            colors.add(List.of(color, color));
        }
        return ColorPicker.createColorMatrix(x1, y1, x2, y2, colors);
    }

    private static List<VertexInfo> createColorMatrix(int x1, int y1, int x2, int y2, List<List<ColorValue>> list) {
        ImmutableList.Builder vertices = ImmutableList.builder();
        for (int i = 0; i < list.size() - 1; ++i) {
            float v1 = (float)i / (float)(list.size() - 1);
            float v2 = (float)(i + 1) / (float)(list.size() - 1);
            for (int j = 0; j < list.get(i).size() - 1; ++j) {
                float u1 = (float)j / (float)(list.get(i).size() - 1);
                float u2 = (float)(j + 1) / (float)(list.get(i).size() - 1);
                float cx1 = Mth.m_14179_((float)u1, (float)x1, (float)x2);
                float cx2 = Mth.m_14179_((float)u2, (float)x1, (float)x2);
                float cy1 = Mth.m_14179_((float)v1, (float)y1, (float)y2);
                float cy2 = Mth.m_14179_((float)v2, (float)y1, (float)y2);
                vertices.add((Object)new VertexInfo(cx1, cy1, u1, v1, list.get(i).get(j)));
                vertices.add((Object)new VertexInfo(cx1, cy2, u1, v2, list.get(i + 1).get(j)));
                vertices.add((Object)new VertexInfo(cx2, cy2, u2, v2, list.get(i + 1).get(j + 1)));
                vertices.add((Object)new VertexInfo(cx2, cy1, u2, v1, list.get(i).get(j + 1)));
            }
        }
        return vertices.build();
    }

    private static class ValueSlider
    extends AbstractSliderButton {
        private final String translationKey;
        private final Supplier<Integer> getter;
        private final Consumer<Integer> setter;

        public ValueSlider(int x, int y, int width, int height, String translationKey, Supplier<Integer> getter, Consumer<Integer> setter) {
            super(x, y, width, height, (Component)new TextComponent(""), (double)Mth.m_14045_((int)getter.get(), (int)0, (int)255) / 255.0);
            this.translationKey = translationKey;
            this.getter = getter;
            this.setter = setter;
        }

        protected void m_5695_() {
            this.m_93666_((Component)new TranslatableComponent(this.translationKey, new Object[]{this.getter.get()}));
        }

        protected void m_5697_() {
            this.setter.accept(Mth.m_14045_((int)((int)Math.round(this.f_93577_ * 255.0)), (int)0, (int)255));
        }

        public void update() {
            this.f_93577_ = (double)Mth.m_14045_((int)this.getter.get(), (int)0, (int)255) / 255.0;
            this.m_5695_();
        }
    }

    private record ColorValue(int red, int green, int blue) {
        public static ColorValue create(int value) {
            int rgb = 0xFFFFFF & value;
            return new ColorValue(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
    }

    private record VertexInfo(float x, float y, float u, float v, ColorValue color) {
        public void add(VertexConsumer vertex, Matrix4f matrix) {
            vertex.m_85982_(matrix, this.x, this.y, 20.0f).m_6122_(this.color.red, this.color.green, this.color.blue, 255).m_7421_(this.u, this.v).m_5752_();
        }

        public void addGrayscale(VertexConsumer vertex, Matrix4f matrix) {
            int value = Math.round((float)(this.color.red + this.color.green + this.color.blue) / 3.0f);
            vertex.m_85982_(matrix, this.x, this.y, 20.0f).m_6122_(value, value, value, 255).m_7421_(this.u, this.v).m_5752_();
        }
    }
}

