/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedFenceGateBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedPressurePlate;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedSign;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedSlabBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedStairBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedStoneButton;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import io.github.noeppi_noeppi.libx.impl.base.decoration.blocks.DecoratedWoodButton;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockStateProviderBase
extends BlockStateProvider {
    public static final ResourceLocation LEAVES_PARENT = new ResourceLocation("minecraft", "block/leaves");
    public static final ResourceLocation BUTTON_PARENT = new ResourceLocation("minecraft", "block/button");
    public static final ResourceLocation PRESSED_BUTTON_PARENT = new ResourceLocation("minecraft", "block/button_pressed");
    public static final ResourceLocation PRESSURE_PLATE_PARENT = new ResourceLocation("minecraft", "block/pressure_plate_up");
    public static final ResourceLocation PRESSED_PRESSURE_PLATE_PARENT = new ResourceLocation("minecraft", "block/pressure_plate_down");
    protected final ModX mod;
    private static final Set<Block> manualState = new HashSet<Block>();
    private static final Set<Block> existingModel = new HashSet<Block>();
    private static final Map<Block, ModelFile> customModel = new HashMap<Block, ModelFile>();

    public BlockStateProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, mod.modid, fileHelper);
        this.mod = mod;
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " block states and models";
    }

    protected void manualState(Block b) {
        manualState.add(b);
    }

    protected void manualModel(Block b) {
        existingModel.add(b);
    }

    protected void manualModel(Block b, ModelFile model) {
        customModel.put(b, model);
    }

    protected final void registerStatesAndModels() {
        this.setup();
        for (ResourceLocation id : ForgeRegistries.BLOCKS.getKeys()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null || !this.mod.modid.equals(id.m_135827_()) || manualState.contains(block)) continue;
            if (existingModel.contains(block)) {
                this.defaultState(id, block, () -> this.models().getExistingFile(new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_())));
                continue;
            }
            if (customModel.containsKey(block)) {
                this.defaultState(id, block, () -> customModel.get(block));
                continue;
            }
            LazyValue<ModelFile> defaultModel = new LazyValue<ModelFile>(() -> this.defaultModel(id, block));
            this.defaultState(id, block, defaultModel::get);
        }
    }

    protected abstract void setup();

    protected void defaultState(ResourceLocation id, Block block, Supplier<ModelFile> model) {
        if (block instanceof DecoratedSlabBlock) {
            DecoratedSlabBlock decorated = (DecoratedSlabBlock)block;
            this.slabBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()), BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedStairBlock) {
            DecoratedStairBlock decorated = (DecoratedStairBlock)block;
            this.stairsBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedWallBlock) {
            DecoratedWallBlock decorated = (DecoratedWallBlock)block;
            this.wallBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedFenceBlock) {
            DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
            this.fenceBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedFenceGateBlock) {
            DecoratedFenceGateBlock decorated = (DecoratedFenceGateBlock)block;
            this.fenceGateBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedWoodButton) {
            DecoratedWoodButton decorated = (DecoratedWoodButton)block;
            this.buttonBlock((ButtonBlock)decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedStoneButton) {
            DecoratedStoneButton decorated = (DecoratedStoneButton)block;
            this.buttonBlock((ButtonBlock)decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedPressurePlate) {
            DecoratedPressurePlate decorated = (DecoratedPressurePlate)block;
            this.pressurePlateBlock(decorated, BlockStateProviderBase.textureId(decorated.parent.getRegistryName()));
        } else if (block instanceof DecoratedDoorBlock) {
            DecoratedDoorBlock decorated = (DecoratedDoorBlock)block;
            this.doorBlock(decorated, BlockStateProviderBase.textureId(id, "bottom"), BlockStateProviderBase.textureId(id, "top"));
        } else if (block instanceof DecoratedTrapdoorBlock) {
            DecoratedTrapdoorBlock decorated = (DecoratedTrapdoorBlock)block;
            this.trapdoorBlock(decorated, BlockStateProviderBase.textureId(id), true);
        } else if (block instanceof DecoratedSign.Standing) {
            DecoratedSign.Standing decorated = (DecoratedSign.Standing)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.m_135815_())).texture("particle", BlockStateProviderBase.textureId(decorated.parent.getRegistryName())))});
        } else if (block instanceof DecoratedSign.Wall) {
            DecoratedSign.Wall decorated = (DecoratedSign.Wall)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.m_135815_())).texture("particle", BlockStateProviderBase.textureId(decorated.parent.getRegistryName())))});
        } else if (block.m_49965_().m_61092_().contains(BlockStateProperties.f_61374_)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
                builder.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model.get(), 0, (int)direction.m_122424_().m_122435_(), false)});
            }
        } else if (block.m_49965_().m_61092_().contains(BlockStateProperties.f_61372_)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
                builder.partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model.get(), direction == Direction.DOWN ? 180 : (direction.m_122434_().m_122479_() ? 90 : 0), direction.m_122434_().m_122478_() ? 0 : (int)direction.m_122424_().m_122435_(), false)});
            }
        } else {
            this.simpleBlock(block, model.get());
        }
    }

    protected ModelFile defaultModel(ResourceLocation id, Block block) {
        if (block.m_49965_().m_61056_().stream().allMatch(state -> state.m_60799_() != RenderShape.MODEL)) {
            if (block instanceof LiquidBlock) {
                LiquidBlock fluidBlock = (LiquidBlock)block;
                return ((BlockModelBuilder)this.models().getBuilder(id.m_135815_())).texture("particle", fluidBlock.getFluid().getAttributes().getStillTexture());
            }
            return this.models().getBuilder(id.m_135815_());
        }
        if (block instanceof LeavesBlock) {
            return ((BlockModelBuilder)this.models().withExistingParent(Objects.requireNonNull(block.getRegistryName()).m_135815_(), LEAVES_PARENT)).texture("all", this.blockTexture(block));
        }
        return this.cubeAll(block);
    }

    public void buttonBlock(Block block, ResourceLocation texture) {
        ResourceLocation blockId = Objects.requireNonNull(block.getRegistryName());
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), BUTTON_PARENT)).texture("texture", texture);
        ModelBuilder pressedModel = ((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + "_pressed", PRESSED_BUTTON_PARENT)).texture("texture", texture);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (AttachFace face : BlockStateProperties.f_61376_.m_6908_()) {
            for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
                builder.partialState().with((Property)BlockStateProperties.f_61376_, (Comparable)face).with((Property)BlockStateProperties.f_61374_, (Comparable)direction).with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, face.ordinal() * 90, (int)direction.m_122424_().m_122435_(), false)});
                builder.partialState().with((Property)BlockStateProperties.f_61376_, (Comparable)face).with((Property)BlockStateProperties.f_61374_, (Comparable)direction).with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressedModel, face.ordinal() * 90, (int)direction.m_122424_().m_122435_(), false)});
            }
        }
    }

    public void pressurePlateBlock(Block block, ResourceLocation texture) {
        ResourceLocation blockId = Objects.requireNonNull(block.getRegistryName());
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), PRESSURE_PLATE_PARENT)).texture("texture", texture);
        ModelBuilder pressedModel = ((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + "_down", PRESSED_PRESSURE_PLATE_PARENT)).texture("texture", texture);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        builder.partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressedModel)});
    }

    private static ResourceLocation textureId(ResourceLocation blockId) {
        Objects.requireNonNull(blockId);
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_());
    }

    private static ResourceLocation textureId(ResourceLocation blockId, String suffix) {
        Objects.requireNonNull(blockId);
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_() + "_" + suffix);
    }
}

