/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.annotation.meta.RemoveIn;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NbtIngredient
extends Ingredient {
    private final ItemStack stack;
    private final ItemStack[] matchingStacks;
    public final boolean exactMatch;

    public NbtIngredient(ItemStack stack) {
        this(stack, false);
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.19")
    public NbtIngredient(ItemStack stack, boolean exactMatch) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack.m_41777_();
        this.exactMatch = exactMatch;
        this.matchingStacks = new ItemStack[]{stack.m_41777_()};
    }

    public boolean test(@Nullable ItemStack input) {
        CompoundTag inputNbt;
        if (input == null || this.stack.m_41619_() || input.m_41720_() != this.stack.m_41720_()) {
            return false;
        }
        if (input.m_41763_() != this.stack.m_41763_() || this.stack.m_41763_() && input.m_41773_() != this.stack.m_41773_()) {
            return false;
        }
        CompoundTag nbt = this.stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        if ((inputNbt = input.m_41783_()) == null) {
            inputNbt = new CompoundTag();
        }
        if (this.exactMatch) {
            return inputNbt.equals((Object)nbt);
        }
        CompoundTag merged = inputNbt.m_6426_();
        merged = merged.m_128391_(nbt);
        return merged.equals((Object)inputNbt);
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        return this.matchingStacks;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.m_41720_().getRegistryName().toString());
        if (this.stack.m_41782_() && !this.stack.m_41784_().m_128456_()) {
            json.addProperty("nbt", this.stack.m_41783_().toString());
        }
        json.addProperty("exactMatch", Boolean.valueOf(this.exactMatch));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NbtIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public NbtIngredient parse(FriendlyByteBuf buffer) {
            return new NbtIngredient(buffer.m_130267_(), buffer.readBoolean());
        }

        @Nonnull
        public NbtIngredient parse(@Nonnull JsonObject json) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            return new NbtIngredient(stack, json.has("exactMatch") && json.get("exactMatch").getAsBoolean());
        }

        public void write(FriendlyByteBuf buffer, NbtIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
            buffer.writeBoolean(ingredient.exactMatch);
        }
    }
}

