/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.noeppi_noeppi.libx.LibX;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;

public class EnumArgument2<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;
    private final DynamicCommandExceptionType invalidValue;

    public static <R extends Enum<R>> EnumArgument2<R> enumArgument(Class<R> enumClass) {
        return new EnumArgument2<R>(enumClass);
    }

    private EnumArgument2(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Can't create enum argument for non-enum class.");
        }
        this.enumClass = enumClass;
        this.invalidValue = new DynamicCommandExceptionType(name -> new TranslatableComponent("libx.command.argument.enum.invalid", new Object[]{enumClass.getSimpleName(), name}));
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String str = reader.readUnquotedString().toLowerCase(Locale.ROOT);
        for (Enum t : (Enum[])this.enumClass.getEnumConstants()) {
            if (!t.name().toLowerCase(Locale.ROOT).equals(str)) continue;
            return (T)t;
        }
        throw this.invalidValue.createWithContext((ImmutableStringReader)reader, (Object)str);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(str -> str.toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public static class Serializer
    implements ArgumentSerializer<EnumArgument2<?>> {
        public void serializeToNetwork(EnumArgument2 argument, FriendlyByteBuf buffer) {
            buffer.m_130070_(argument.enumClass.getName());
        }

        @Nonnull
        public EnumArgument2 deserializeFromNetwork(FriendlyByteBuf buffer) {
            String name = buffer.m_130277_();
            try {
                return new EnumArgument2(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                LibX.logger.warn("Can't get enum value of type " + name + "in command argument. " + e.getMessage());
                return null;
            }
        }

        public void serializeToJson(EnumArgument2 argument, JsonObject json) {
            json.addProperty("enum", argument.enumClass.getName());
        }
    }
}

