/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.observer;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.observer.TrackObserver;
import com.simibubi.create.content.logistics.trains.management.edgePoint.observer.TrackObserverBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrackObserverTileEntity
extends SmartTileEntity
implements ITransformableTE {
    public TrackTargetingBehaviour<TrackObserver> edgePoint;
    private FilteringBehaviour filtering;

    public TrackObserverTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<TrackObserver>(this, EdgePointType.OBSERVER);
        behaviours.add(this.edgePoint);
        this.filtering = this.createFilter().withCallback(this::onFilterChanged);
        behaviours.add(this.filtering);
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            observer.setFilterAndNotify(this.f_58857_, newFilter);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean shouldBePowered = false;
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            shouldBePowered = observer.isActivated();
        }
        if (this.isBlockPowered() == shouldBePowered) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)TrackObserverBlock.POWERED)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        }
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
    }

    @Nullable
    public TrackObserver getObserver() {
        return this.edgePoint.getEdgePoint();
    }

    public ItemStack getFilter() {
        return this.filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return this.m_58900_().m_61145_((Property)TrackObserverBlock.POWERED).orElse(false);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82400_(2.0);
    }

    @Override
    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            protected void rotate(BlockState state, PoseStack ms) {
                TransformStack.cast((PoseStack)ms).rotateX(90.0);
            }

            @Override
            protected Vec3 getLocalOffset(BlockState state) {
                return new Vec3(0.5, 0.9375, 0.5);
            }

            @Override
            protected float getScale() {
                return super.getScale() * 1.5f;
            }
        });
    }
}

