/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.wrench;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IWrenchableWithBracket
extends IWrenchable {
    public Optional<ItemStack> removeBracket(BlockGetter var1, BlockPos var2, boolean var3);

    @Override
    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.tryRemoveBracket(context)) {
            return InteractionResult.SUCCESS;
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    default public boolean tryRemoveBracket(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Optional<ItemStack> bracket = this.removeBracket((BlockGetter)world, pos, false);
        BlockState blockState = world.m_8055_(pos);
        if (bracket.isPresent()) {
            Player player = context.m_43723_();
            if (!world.f_46443_ && !player.m_7500_()) {
                player.m_150109_().m_150079_(bracket.get());
            }
            if (!world.f_46443_ && AllBlocks.FLUID_PIPE.has(blockState)) {
                Direction.Axis preferred = FluidPropagator.getStraightPipeAxis(blockState);
                Direction preferredDirection = preferred == null ? Direction.UP : Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)preferred);
                BlockState updated = ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(blockState, preferredDirection, null, (BlockAndTintGetter)world, pos);
                if (updated != blockState) {
                    world.m_46597_(pos, updated);
                }
            }
            return true;
        }
        return false;
    }
}

