/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WaterWheelBlock
extends DirectionalKineticBlock
implements ITE<WaterWheelTileEntity> {
    public WaterWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos = pos.m_142300_(direction);
            BlockState neighbourState = worldIn.m_8055_(neighbourPos);
            if (!AllBlocks.WATER_WHEEL.has(neighbourState) || ((Direction)neighbourState.m_61143_((Property)FACING)).m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_() && ((Direction)state.m_61143_((Property)FACING)).m_122434_() == direction.m_122434_()) continue;
            return false;
        }
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof WrappedWorld) {
            return stateIn;
        }
        this.updateFlowAt(stateIn, worldIn, currentPos, facing);
        this.updateWheelSpeed(worldIn, currentPos);
        return stateIn;
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        this.updateAllSides(state, worldIn, pos);
    }

    public void updateAllSides(BlockState state, Level worldIn, BlockPos pos) {
        for (Direction d : Iterate.directions) {
            this.updateFlowAt(state, (LevelAccessor)worldIn, pos, d);
        }
        this.updateWheelSpeed((LevelAccessor)worldIn, pos);
    }

    private void updateFlowAt(BlockState state, LevelAccessor world, BlockPos pos, Direction side) {
        BlockState adjacentBlock;
        if (side.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            return;
        }
        FluidState fluid = world.m_6425_(pos.m_142300_(side));
        Direction wf = (Direction)state.m_61143_((Property)FACING);
        boolean clockwise = wf.m_122421_() == Direction.AxisDirection.POSITIVE;
        int clockwiseMultiplier = 2;
        Vec3 vec = fluid.m_76179_((BlockGetter)world, pos.m_142300_(side));
        if (side.m_122434_().m_122479_() && (adjacentBlock = world.m_8055_(pos.m_142300_(side))).m_60734_() == Blocks.f_50628_) {
            vec = new Vec3(0.0, (Boolean)adjacentBlock.m_61143_((Property)BubbleColumnBlock.f_50956_) != false ? -1.0 : 1.0, 0.0);
        }
        vec = vec.m_82490_((double)side.m_122421_().m_122540_());
        Vec3 flow = vec = new Vec3(Math.signum(vec.f_82479_), Math.signum(vec.f_82480_), Math.signum(vec.f_82481_));
        this.withTileEntityDo((BlockGetter)world, pos, te -> {
            double flowStrength = 0.0;
            if (wf.m_122434_() == Direction.Axis.Z) {
                if (side.m_122434_() == Direction.Axis.Y) {
                    double d = flowStrength = flow.f_82479_ > 0.0 ^ !clockwise ? -flow.f_82479_ * (double)clockwiseMultiplier : -flow.f_82479_;
                }
                if (side.m_122434_() == Direction.Axis.X) {
                    double d = flowStrength = flow.f_82480_ < 0.0 ^ !clockwise ? flow.f_82480_ * (double)clockwiseMultiplier : flow.f_82480_;
                }
            }
            if (wf.m_122434_() == Direction.Axis.X) {
                if (side.m_122434_() == Direction.Axis.Y) {
                    double d = flowStrength = flow.f_82481_ < 0.0 ^ !clockwise ? flow.f_82481_ * (double)clockwiseMultiplier : flow.f_82481_;
                }
                if (side.m_122434_() == Direction.Axis.Z) {
                    double d = flowStrength = flow.f_82480_ > 0.0 ^ !clockwise ? -flow.f_82480_ * (double)clockwiseMultiplier : -flow.f_82480_;
                }
            }
            if (wf.m_122434_() == Direction.Axis.Y) {
                if (side.m_122434_() == Direction.Axis.Z) {
                    double d = flowStrength = flow.f_82479_ < 0.0 ^ !clockwise ? flow.f_82479_ * (double)clockwiseMultiplier : flow.f_82479_;
                }
                if (side.m_122434_() == Direction.Axis.X) {
                    double d = flowStrength = flow.f_82481_ > 0.0 ^ !clockwise ? -flow.f_82481_ * (double)clockwiseMultiplier : -flow.f_82481_;
                }
            }
            if (te.getSpeed() == 0.0f && flowStrength != 0.0 && !world.m_5776_()) {
                te.award(FluidHelper.isLava(fluid.m_76152_()) ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
            }
            Integer flowModifier = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
            te.setFlow(side, (float)(flowStrength * (double)flowModifier.intValue() / 2.0));
        });
    }

    private void updateWheelSpeed(LevelAccessor world, BlockPos pos) {
        this.withTileEntityDo((BlockGetter)world, pos, GeneratingKineticTileEntity::updateGeneratedRotation);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean sneaking;
        Direction face = context.m_43719_();
        Direction horizontalFacing = context.m_8125_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockState placedOn = world.m_8055_(pos.m_142300_(face.m_122424_()));
        if (AllBlocks.WATER_WHEEL.has(placedOn)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)placedOn.m_61143_((Property)FACING)));
        }
        Direction facing = face;
        boolean bl = sneaking = player != null && player.m_6144_();
        if (player != null) {
            Vec3 lookVec = player.m_20154_();
            double tolerance = 0.985;
            facing = !this.m_7898_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP), (LevelReader)world, pos) ? horizontalFacing : (Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_()).m_82526_(lookVec.m_82541_()) > tolerance ? Direction.DOWN : (Vec3.m_82528_((Vec3i)Direction.UP.m_122436_()).m_82526_(lookVec.m_82541_()) > tolerance ? Direction.UP : horizontalFacing));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(sneaking ? facing.m_122424_() : facing));
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == face.m_122434_();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public boolean hideStressImpact() {
        return true;
    }

    @Override
    public Class<WaterWheelTileEntity> getTileEntityClass() {
        return WaterWheelTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends WaterWheelTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.WATER_WHEEL.get();
    }

    public static Couple<Integer> getSpeedRange() {
        Integer base = (Integer)AllConfigs.SERVER.kinetics.waterWheelBaseSpeed.get();
        Integer flow = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
        return Couple.create(base, base + 4 * flow);
    }
}

