/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.model;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.TransporterModelData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterBlockModel
implements IDynamicBakedModel {
    public static Cache<Pair<Pair<String, Pair<Direction, TransporterTypeFactory.TransporterAction>>, Direction>, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build();
    private VertexFormat format;
    private BakedModel previousModel;
    private Map<Direction, List<BakedQuad>> prevQuads = new HashMap<Direction, List<BakedQuad>>();

    public TransporterBlockModel(BakedModel previousConveyor) {
        this.previousModel = previousConveyor;
        this.format = DefaultVertexFormat.f_85811_;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        CACHE.invalidateAll();
        if (state == null) {
            if (!this.prevQuads.containsKey(side)) {
                this.prevQuads.put(side, this.previousModel.m_6840_(state, side, rand));
            }
            return this.prevQuads.get(side);
        }
        if (!this.prevQuads.containsKey(side)) {
            this.prevQuads.put(side, this.previousModel.m_6840_(state, side, rand));
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)this.prevQuads.get(side));
        if (extraData.hasProperty(TransporterModelData.UPGRADE_PROPERTY)) {
            for (TransporterType upgrade : ((TransporterModelData)extraData.getData(TransporterModelData.UPGRADE_PROPERTY)).getUpgrades().values()) {
                if (upgrade == null) continue;
                List upgradeQuads = (List)CACHE.getIfPresent((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Object)upgrade.getAction()))), (Object)side));
                if (upgradeQuads == null) {
                    try {
                        BakedModel model = ModuleTransportStorage.TRANSPORTER_CACHE.get(upgrade.getFactory().getModel(upgrade.getSide(), upgrade.getAction()));
                        upgradeQuads = model.getQuads(state, side, rand, extraData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    CACHE.put((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Object)upgrade.getAction()))), (Object)side), (Object)upgradeQuads);
                }
                if (upgradeQuads.isEmpty()) continue;
                quads.addAll(upgradeQuads);
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.previousModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.previousModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.previousModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.previousModel.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.previousModel.m_6160_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.previousModel.m_7343_();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return this.previousModel.handlePerspective(cameraTransformType, mat);
    }

    public ItemTransforms m_7442_() {
        return this.previousModel.m_7442_();
    }
}

