/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.block.core.tile.DissolutionChamberTile;
import com.buuz135.industrial.config.machine.core.DissolutionChamberConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class DissolutionChamberCategory
implements IRecipeCategory<DissolutionChamberRecipe> {
    private final IGuiHelper guiHelper;
    private final IDrawable smallTank;
    private final IDrawable bigTank;

    public DissolutionChamberCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
        this.bigTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 180, 4, 12, 50);
    }

    public ResourceLocation getUid() {
        return IndustrialRecipeTypes.DISSOLUTION.getUid();
    }

    public Class<? extends DissolutionChamberRecipe> getRecipeClass() {
        return IndustrialRecipeTypes.DISSOLUTION.getRecipeClass();
    }

    public RecipeType<DissolutionChamberRecipe> getRecipeType() {
        return IndustrialRecipeTypes.DISSOLUTION;
    }

    public Component getTitle() {
        return new TranslatableComponent(((Block)((RegistryObject)ModuleCore.DISSOLUTION_CHAMBER.getLeft()).get()).m_7705_());
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(160, 82);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DissolutionChamberRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < 8; ++i) {
            if (i >= recipe.input.length) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, 24 + (Integer)DissolutionChamberTile.getSlotPos(i).getLeft(), 11 + (Integer)DissolutionChamberTile.getSlotPos(i).getRight()).addIngredients(VanillaTypes.ITEM, recipe.input[i].m_6223_().stream().toList());
        }
        if (recipe.inputFluid != null && !recipe.inputFluid.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 35).setFluidRenderer(1000, false, 12, 13).setOverlay(this.smallTank, 0, 0).addIngredient(VanillaTypes.FLUID, (Object)recipe.inputFluid);
        }
        if (!recipe.output.m_41619_()) {
            ItemStack stack = recipe.output;
            stack.m_41720_().m_7836_(stack, null, null);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 119, 16).addIngredient(VanillaTypes.ITEM, (Object)stack);
        }
        if (recipe.outputFluid != null && !recipe.outputFluid.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 17).setFluidRenderer(1000, false, 12, 50).setOverlay(this.bigTank, 0, 0).addIngredient(VanillaTypes.FLUID, (Object)recipe.outputFluid);
        }
    }

    public void draw(DissolutionChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        EnergyBarScreenAddon.drawBackground((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0);
        SlotsScreenAddon.drawAsset((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)24, (int)11, (int)0, (int)0, (int)8, DissolutionChamberTile::getSlotPos, integer -> ItemStack.f_41583_, (boolean)true, integer -> new Color(DyeColor.LIGHT_BLUE.m_41070_()), integer -> true);
        SlotsScreenAddon.drawAsset((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)119, (int)16, (int)0, (int)0, (int)3, integer -> Pair.of((Object)(18 * (integer % 1)), (Object)(18 * (integer / 1))), integer -> ItemStack.f_41583_, (boolean)true, integer -> new Color(DyeColor.ORANGE.m_41070_()), integer -> true);
        AssetUtil.drawAsset((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL), (int)45, (int)32);
        AssetUtil.drawAsset((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_NORMAL), (int)139, (int)14);
        AssetUtil.drawAsset((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAsset)IAssetProvider.getAsset((IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (IAssetType)AssetTypes.PROGRESS_BAR_BACKGROUND_ARROW_HORIZONTAL), (int)92, (int)33);
        int consumed = recipe.processingTime * DissolutionChamberConfig.powerPerTick;
        EnergyBarScreenAddon.drawForeground((PoseStack)stack, (Screen)Minecraft.m_91087_().f_91080_, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)0, (int)12, (int)0, (int)0, (double)consumed, (double)((int)Math.max(50000.0, Math.ceil(consumed))));
    }

    public List<Component> getTooltipStrings(DissolutionChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Rectangle rec = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.ENERGY_BACKGROUND).getArea();
        if (new Rectangle(0, 12, rec.width, rec.height).contains(mouseX, mouseY)) {
            int consumed = recipe.processingTime * 60;
            return EnergyBarScreenAddon.getTooltip((int)consumed, (int)((int)Math.max(50000.0, Math.ceil(consumed))));
        }
        return new ArrayList<Component>();
    }
}

