/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.MechanicalDirtConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalDirtTile
extends IndustrialWorkingTile<MechanicalDirtTile> {
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<MechanicalDirtTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", MechanicalDirtConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.MEAT.getSourceFluid().get()));

    public MechanicalDirtTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.MECHANICAL_DIRT, MechanicalDirtConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.meat);
        this.getPowerPerOperation = MechanicalDirtConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        Mob entity;
        if (this.f_58857_.f_46441_.nextDouble() > 0.1 || this.f_58857_.m_46791_() == Difficulty.PEACEFUL || this.f_58857_.m_46461_() && this.f_58857_.m_46863_(this.f_58858_.m_7494_()) > 0.5f && this.f_58857_.m_46861_(this.f_58858_.m_7494_()) || this.f_58857_.m_45976_(Mob.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(this.f_58858_).m_82400_(3.0)).size() > 10 || this.f_58857_.m_46803_(this.f_58858_.m_7494_()) > 7) {
            if (this.hasEnergy(this.getPowerPerOperation / 10)) {
                return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation / 10);
            }
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        if (this.meat.getFluidAmount() >= 20 && this.isServer() && (entity = this.getMobToSpawn()) != null) {
            this.f_58857_.m_7967_((Entity)entity);
            this.meat.drainForced(20, IFluidHandler.FluidAction.EXECUTE);
            if (this.hasEnergy(this.getPowerPerOperation)) {
                return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private Mob getMobToSpawn() {
        List spawnListEntries = ((ServerLevel)this.f_58857_).m_7726_().m_8481_().m_203315_(this.f_58857_.m_204166_(this.f_58858_.m_7494_()), ((ServerLevel)this.f_58857_).m_8595_(), MobCategory.MONSTER, this.f_58858_.m_7494_()).m_146338_();
        if (spawnListEntries.size() == 0) {
            return null;
        }
        MobSpawnSettings.SpawnerData spawnListEntry = (MobSpawnSettings.SpawnerData)spawnListEntries.get(this.f_58857_.f_46441_.nextInt(spawnListEntries.size()));
        if (!SpawnPlacements.m_21759_((EntityType)spawnListEntry.f_48404_, (ServerLevelAccessor)((ServerLevelAccessor)this.f_58857_), (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)this.f_58858_.m_7494_(), (Random)this.f_58857_.f_46441_)) {
            return null;
        }
        Entity entity = spawnListEntry.f_48404_.m_20615_(this.f_58857_);
        if (entity instanceof Mob) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(this.f_58858_), MobSpawnType.NATURAL, null, null);
            entity.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.001, (double)this.f_58858_.m_123343_() + 0.5);
            if (this.f_58857_.m_45786_(entity) && this.f_58857_.m_5450_(entity, this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60808_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()))) {
                return (Mob)entity;
            }
        }
        return null;
    }

    public SidedFluidTankComponent<MechanicalDirtTile> getMeat() {
        return this.meat;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, MechanicalDirtTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.f_58857_.m_46467_() % 5L == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockEntity tile = level.m_7702_(this.f_58858_.m_142300_(direction));
                if (!(tile instanceof MechanicalDirtTile)) continue;
                int difference = this.meat.getFluidAmount() - ((MechanicalDirtTile)tile).getMeat().getFluidAmount();
                if (difference > 0) {
                    difference = difference <= 25 ? (difference /= 2) : 25;
                    if (this.meat.getFluidAmount() >= difference) {
                        this.meat.drainForced(((MechanicalDirtTile)tile).getMeat().fill(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), this.meat.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.getEnergyStorage().getEnergyStored() - ((MechanicalDirtTile)tile).getEnergyStorage().getEnergyStored()) <= 0) continue;
                if (difference <= 1000 && difference > 1) {
                    difference /= 2;
                }
                if (difference > 1000) {
                    difference = 1000;
                }
                if (this.getEnergyStorage().getEnergyStored() < difference) continue;
                this.getEnergyStorage().extractEnergy(((MechanicalDirtTile)tile).getEnergyStorage().receiveEnergy(difference, false), false);
            }
        }
    }

    protected EnergyStorageComponent<MechanicalDirtTile> createEnergyStorage() {
        return new EnergyStorageComponent(MechanicalDirtConfig.maxStoredPower, 10, 20);
    }

    @Nonnull
    public MechanicalDirtTile getSelf() {
        return this;
    }
}

