/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.BlockBreakerConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockBreakerTile
extends IndustrialAreaWorkingTile<BlockBreakerTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedInventoryComponent<BlockBreakerTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 54, 22, 18, 0).setColor(DyeColor.ORANGE).setRange(6, 3);

    public BlockBreakerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.BLOCK_BREAKER, RangeManager.RangeType.BEHIND, false, BlockBreakerConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.output);
        this.getMaxProgress = BlockBreakerConfig.maxProgress;
        this.getPowerPerOperation = BlockBreakerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            BlockPos pointed = this.getPointedBlockPos();
            if (this.isLoaded(pointed) && !this.f_58857_.m_46859_(pointed) && BlockUtils.canBlockBeBroken(this.f_58857_, pointed)) {
                FakePlayer fakePlayer = IndustrialForegoing.getFakePlayer(this.f_58857_, pointed);
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42390_));
                if (this.f_58857_.m_8055_(pointed).m_60800_((BlockGetter)this.f_58857_, pointed) >= 0.0f && this.f_58857_.m_8055_(pointed).canHarvestBlock((BlockGetter)this.f_58857_, pointed, (Player)fakePlayer)) {
                    for (ItemStack blockDrop : BlockUtils.getBlockDrops(this.f_58857_, pointed)) {
                        ItemStack result = ItemHandlerHelper.insertItem(this.output, (ItemStack)blockDrop, (boolean)false);
                        if (result.m_41619_()) continue;
                        BlockUtils.spawnItemStack(result, this.f_58857_, pointed);
                    }
                    this.f_58857_.m_46597_(pointed, Blocks.f_50016_.m_49966_());
                    this.increasePointer();
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
                }
            } else {
                this.increasePointer();
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<BlockBreakerTile> createEnergyStorage() {
        return new EnergyStorageComponent(BlockBreakerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BlockBreakerTile getSelf() {
        return this;
    }
}

