/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DeathGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "death";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> (Integer)this.calculate((ItemStack)stack).getLeft() > 0);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41777_();
            ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41774_(1);
            return this.calculate(stack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.YELLOW};
    }

    @Override
    public Item getDisplay() {
        return Items.f_42679_;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Item item : new Item[]{Items.f_42583_, Items.f_42500_, Items.f_42262_, Items.f_42679_}) {
            ItemStack stack = new ItemStack((ItemLike)item);
            Pair<Integer, Integer> power = this.calculate(stack);
            recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
        }
        return recipes;
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42583_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42500_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42583_ || stack.m_41720_() == Items.f_42500_ || stack.m_41720_() == Items.f_42262_ || stack.m_41720_() == Items.f_42679_) {
            return Pair.of((Object)200, (Object)20);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public void onTick(Level world, BlockPos pos) {
        AABB area = new AABB((double)(pos.m_123341_() - 3), (double)(pos.m_123342_() - 3), (double)(pos.m_123343_() - 3), (double)(pos.m_123341_() + 3), (double)(pos.m_123342_() + 3), (double)(pos.m_123343_() + 3));
        for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, area)) {
            livingEntity.m_6469_(DamageSource.f_19318_, 0.5f);
        }
    }
}

