/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.MobCrusherConfig;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.LangUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MobCrusherTile
extends IndustrialAreaWorkingTile<MobCrusherTile> {
    private final Method GET_EXPERIENCE_POINTS = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6552_", (Class[])new Class[]{Player.class});
    private final Method DROP_SPECIAL_ITEMS = ObfuscationReflectionHelper.findMethod(Mob.class, (String)"m_7472_", (Class[])new Class[]{DamageSource.class, Integer.TYPE, Boolean.TYPE});
    @Save
    private SidedInventoryComponent<MobCrusherTile> output;
    @Save
    private SidedFluidTankComponent<MobCrusherTile> tank;
    @Save
    private boolean dropXP;
    private ButtonComponent buttonComponent;

    public MobCrusherTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.MOB_CRUSHER, RangeManager.RangeType.BEHIND, true, MobCrusherConfig.powerPerOperation, blockPos, blockState);
        if (!this.GET_EXPERIENCE_POINTS.isAccessible()) {
            this.GET_EXPERIENCE_POINTS.setAccessible(true);
        }
        if (!this.DROP_SPECIAL_ITEMS.isAccessible()) {
            this.DROP_SPECIAL_ITEMS.setAccessible(true);
        }
        this.dropXP = true;
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", MobCrusherConfig.tankSize, 43, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_205067_(IndustrialTags.Fluids.EXPERIENCE));
        this.addTank(this.tank);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 64, 22, 18, 1).setColor(DyeColor.ORANGE).setRange(6, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.buttonComponent = new ButtonComponent(118, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.produce", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.produce_extra"}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.consume", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.consume_extra_1", "tooltip.industrialforegoing.mob_crusher.consume_extra_2"})}){

                    public int getState() {
                        return MobCrusherTile.this.dropXP ? 0 : 1;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.dropXP = !this.dropXP;
            this.markForUpdate();
        });
        this.addButton(this.buttonComponent);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(MobCrusherConfig.powerPerOperation) && (mobs = this.f_58857_.m_45976_(Mob.class, this.getWorkingArea().m_83215_()).stream().filter(mobEntity -> !(mobEntity instanceof Animal && mobEntity.m_6162_() || mobEntity.m_20147_() || mobEntity instanceof WitherBoss && ((WitherBoss)mobEntity).m_31502_() > 0)).filter(LivingEntity::m_6084_).collect(Collectors.toList())).size() > 0) {
            Mob entity = (Mob)mobs.get(0);
            FakePlayer player = IndustrialForegoing.getFakePlayer(this.f_58857_);
            if (ForgeRegistries.ENTITIES.tags().getTag(IndustrialTags.EntityTypes.MOB_CRUSHER_INSTANT_KILL_BLACKLIST).contains((Object)entity.m_6095_())) {
                return this.damage(entity, player);
            }
            return this.instantKill(entity, player);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private IndustrialWorkingTile.WorkAction instantKill(Mob entity, FakePlayer player) {
        int experience = 0;
        try {
            experience = (Integer)this.GET_EXPERIENCE_POINTS.invoke((Object)entity, player);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        int looting = 0;
        if (!this.dropXP) {
            looting = this.f_58857_.f_46441_.nextInt(4);
            ItemStack sword = new ItemStack((ItemLike)Items.f_42388_);
            EnchantmentHelper.m_44865_(Collections.singletonMap(Enchantments.f_44982_, looting), (ItemStack)sword);
            player.m_21008_(InteractionHand.MAIN_HAND, sword);
        }
        DamageSource source = DamageSource.m_19344_((Player)player);
        LootTable table = this.f_58857_.m_142572_().m_129898_().m_79217_(entity.m_5743_());
        LootContext.Builder context = new LootContext.Builder((ServerLevel)this.f_58857_).m_78977_(this.f_58857_.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81457_, (Object)source).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_())).m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player).m_78984_(LootContextParams.f_81459_, (Object)player);
        table.m_79129_(context.m_78975_(LootContextParamSets.f_81415_)).forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
        ArrayList extra = new ArrayList();
        try {
            if (entity.captureDrops() == null) {
                entity.captureDrops(new ArrayList());
            }
            this.DROP_SPECIAL_ITEMS.invoke((Object)entity, source, looting, true);
            if (entity.captureDrops() != null) {
                extra.addAll(entity.captureDrops());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        ForgeHooks.onLivingDrops((LivingEntity)entity, (DamageSource)source, extra, (int)looting, (boolean)true);
        extra.forEach(itemEntity -> {
            ItemHandlerHelper.insertItem(this.output, (ItemStack)itemEntity.m_32055_(), (boolean)false);
            itemEntity.m_142687_(Entity.RemovalReason.KILLED);
        });
        if (this.dropXP) {
            this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), experience * 20), IFluidHandler.FluidAction.EXECUTE);
        }
        entity.m_21153_(0.0f);
        entity.m_142687_(Entity.RemovalReason.KILLED);
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        return new IndustrialWorkingTile.WorkAction(this, 0.1f, MobCrusherConfig.powerPerOperation);
    }

    private IndustrialWorkingTile.WorkAction damage(Mob entity, FakePlayer player) {
        entity.m_6469_(DamageSource.m_19344_((Player)player).m_19389_(), (float)MobCrusherConfig.attackDamage);
        return new IndustrialWorkingTile.WorkAction(this, 0.1f, MobCrusherConfig.powerPerOperation);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.f_58858_, this.getFacingDirection(), RangeManager.RangeType.BEHIND){

            @Override
            public AABB getBox() {
                return super.getBox().m_82363_(0.0, 2.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    public MobCrusherTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<MobCrusherTile> createEnergyStorage() {
        return new EnergyStorageComponent(MobCrusherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return MobCrusherConfig.maxProgress;
    }
}

