/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors.network;

import de.castcrafter.travel_anchors.TravelAnchorList;
import de.castcrafter.travel_anchors.network.AnchorListUpdateHandler;
import de.castcrafter.travel_anchors.network.AnchorListUpdateSerializer;
import de.castcrafter.travel_anchors.network.AnchorNameChangeHandler;
import de.castcrafter.travel_anchors.network.AnchorNameChangeSerializer;
import de.castcrafter.travel_anchors.network.ClientEventHandler;
import de.castcrafter.travel_anchors.network.ClientEventSerializer;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class Networking
extends NetworkX {
    public Networking(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"5");
    }

    protected void registerPackets() {
        this.register(new AnchorNameChangeSerializer(), () -> AnchorNameChangeHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new AnchorListUpdateSerializer(), () -> AnchorListUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ClientEventSerializer(), () -> ClientEventHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void sendNameChange(Level level, BlockPos pos, String name) {
        if (level.f_46443_) {
            this.channel.sendToServer((Object)new AnchorNameChangeSerializer.AnchorNameChangeMessage(pos, name));
        }
    }

    public void updateTravelAnchorList(Level level, @Nullable TravelAnchorList list) {
        if (!level.f_46443_) {
            if (list == null) {
                list = TravelAnchorList.get(level);
            }
            this.channel.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new AnchorListUpdateSerializer.AnchorListUpdateMessage(list.m_7176_(new CompoundTag())));
        }
    }

    public void updateTravelAnchorList(Player player) {
        if (!player.m_20193_().f_46443_ && player instanceof ServerPlayer) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new AnchorListUpdateSerializer.AnchorListUpdateMessage(TravelAnchorList.get(player.m_20193_()).m_7176_(new CompoundTag())));
        }
    }

    public void sendClientEventToServer(Level level, ClientEventSerializer.ClientEvent event) {
        if (level.f_46443_) {
            this.channel.sendToServer((Object)event);
        }
    }
}

