/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors;

import de.castcrafter.travel_anchors.ModComponents;
import de.castcrafter.travel_anchors.TravelAnchors;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class TravelAnchorList
extends SavedData {
    private static final TravelAnchorList clientInstance = new TravelAnchorList();
    public final HashMap<BlockPos, Entry> anchors = new HashMap();

    public static TravelAnchorList get(Level level) {
        if (!level.f_46443_) {
            DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
            return (TravelAnchorList)storage.m_164861_(TravelAnchorList::new, TravelAnchorList::new, TravelAnchors.getInstance().modid);
        }
        return clientInstance;
    }

    public TravelAnchorList() {
    }

    public TravelAnchorList(CompoundTag nbt) {
        this();
        this.load(nbt);
    }

    public void load(@Nonnull CompoundTag nbt) {
        this.anchors.clear();
        if (nbt.m_128425_("anchors", 9)) {
            ListTag list = nbt.m_128437_("anchors", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryNBT = list.m_128728_(i);
                if (!entryNBT.m_128441_("x") || !entryNBT.m_128441_("y") || !entryNBT.m_128441_("z") || !entryNBT.m_128441_("name")) continue;
                BlockPos pos = new BlockPos(entryNBT.m_128451_("x"), entryNBT.m_128451_("y"), entryNBT.m_128451_("z")).m_7949_();
                String name = entryNBT.m_128461_("name");
                if (name.isEmpty()) continue;
                this.anchors.put(pos, new Entry(entryNBT.m_128461_("name"), entryNBT.m_128441_("state") ? Block.m_49803_((int)entryNBT.m_128451_("state")) : ModComponents.travelAnchor.m_49966_()));
            }
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Entry> entry : this.anchors.entrySet()) {
            CompoundTag entryNBT = new CompoundTag();
            entryNBT.m_128405_("x", entry.getKey().m_123341_());
            entryNBT.m_128405_("y", entry.getKey().m_123342_());
            entryNBT.m_128405_("z", entry.getKey().m_123343_());
            entryNBT.m_128359_("name", entry.getValue().name);
            entryNBT.m_128405_("state", Block.m_49956_((BlockState)entry.getValue().state));
            list.add((Object)entryNBT);
        }
        compound.m_128365_("anchors", (Tag)list);
        return compound;
    }

    public void setAnchor(Level level, BlockPos pos, @Nullable String name, @Nullable BlockState state) {
        if (!level.f_46443_) {
            boolean needsUpdate = false;
            BlockPos immutablePos = pos.m_7949_();
            if (name == null || name.trim().isEmpty()) {
                if (this.anchors.containsKey(immutablePos)) {
                    this.anchors.remove(immutablePos);
                    needsUpdate = true;
                }
            } else {
                Entry oldEntry;
                if (state == null) {
                    state = ModComponents.travelAnchor.m_49966_();
                }
                if ((oldEntry = (Entry)this.anchors.getOrDefault(immutablePos, null)) == null || !oldEntry.name.equals(name) || oldEntry.state != state) {
                    this.anchors.put(pos.m_7949_(), new Entry(name, state));
                    needsUpdate = true;
                }
            }
            this.m_77762_();
            if (needsUpdate) {
                TravelAnchors.getNetwork().updateTravelAnchorList(level, this);
            }
        }
    }

    public String getAnchor(BlockPos pos) {
        Entry entry = this.getEntry(pos);
        return entry == null ? null : entry.name;
    }

    public Entry getEntry(BlockPos pos) {
        return this.anchors.getOrDefault(pos.m_7949_(), null);
    }

    public Stream<Pair<BlockPos, String>> getAnchorsAround(Vec3 pos, double maxDistanceSq) {
        return this.anchors.entrySet().stream().filter(entry -> ((BlockPos)entry.getKey()).m_203198_(pos.f_82479_, pos.f_82480_, pos.f_82481_) < maxDistanceSq).map(entry -> Pair.of((Object)((BlockPos)entry.getKey()), (Object)((Entry)entry.getValue()).name));
    }

    public static class Entry {
        public String name;
        public BlockState state;

        public Entry(String name, BlockState state) {
            this.name = name;
            this.state = state;
        }
    }
}

