/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travel_anchors;

import de.castcrafter.travel_anchors.TeleportHandler;
import de.castcrafter.travel_anchors.TravelAnchors;
import de.castcrafter.travel_anchors.config.ClientConfig;
import de.castcrafter.travel_anchors.network.ClientEventSerializer;
import io.github.noeppi_noeppi.libx.event.ClickBlockEmptyHandEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getPlayer());
    }

    @SubscribeEvent
    public void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getPlayer());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        if (TeleportHandler.canPlayerTeleport(player, event.getHand()) && !event.getItemStack().m_41619_()) {
            if (player.m_6144_() && TeleportHandler.canItemTeleport(player, event.getHand())) {
                if (TeleportHandler.shortTeleport(level, player, event.getHand())) {
                    event.setResult(Event.Result.DENY);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    player.m_36335_().m_41524_(event.getItemStack().m_41720_(), 30);
                }
            } else if (TeleportHandler.anchorTeleport(level, player, player.m_142538_().m_7949_().m_7495_(), event.getHand())) {
                event.setResult(Event.Result.DENY);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onEmptyClick(PlayerInteractEvent.RightClickEmpty event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        if (TeleportHandler.canBlockTeleport(player) && !player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && event.getPlayer().m_21120_(InteractionHand.OFF_HAND).m_41619_() && event.getItemStack().m_41619_()) {
            TravelAnchors.getNetwork().sendClientEventToServer(level, ClientEventSerializer.ClientEvent.EMPTY_HAND_INTERACT);
            event.setResult(Event.Result.DENY);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void emptyBlockClick(ClickBlockEmptyHandEvent event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && TeleportHandler.canPlayerTeleport((Player)event.getPlayer(), event.getHand()) && !event.getPlayer().m_6144_() && TeleportHandler.anchorTeleport(event.getLevel(), (Player)event.getPlayer(), event.getPlayer().m_142538_().m_7949_().m_7495_(), event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ClientConfig.disable_elevation) {
                if (TeleportHandler.canBlockTeleport(player) && !player.m_6144_()) {
                    TravelAnchors.getNetwork().sendClientEventToServer(player.m_20193_(), ClientEventSerializer.ClientEvent.JUMP_TP);
                }
            } else if (TeleportHandler.canElevate(player) && !player.m_6144_()) {
                TravelAnchors.getNetwork().sendClientEventToServer(player.m_20193_(), ClientEventSerializer.ClientEvent.JUMP);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onSneak(MovementInputUpdateEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91066_.f_92090_.m_90859_() && !ClientConfig.disable_elevation && TeleportHandler.canElevate((Player)Minecraft.m_91087_().f_91074_)) {
            TravelAnchors.getNetwork().sendClientEventToServer(Minecraft.m_91087_().f_91074_.m_20193_(), ClientEventSerializer.ClientEvent.SNEAK);
        }
    }
}

