/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.regassets.ConditionRE;
import mcjty.lostcities.worldgen.lost.regassets.data.ConditionPart;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class Condition
implements ILostCityAsset {
    private final ResourceLocation name;
    private final List<Pair<Predicate<ConditionContext>, Pair<Float, String>>> valueSelector = new ArrayList<Pair<Predicate<ConditionContext>, Pair<Float, String>>>();

    public Condition(ConditionRE object) {
        this.name = object.getRegistryName();
        for (ConditionPart cp : object.getValues()) {
            float factor = cp.getFactor();
            String value = cp.getValue();
            Predicate<ConditionContext> test = ConditionContext.parseTest(cp);
            this.valueSelector.add((Pair<Predicate<ConditionContext>, Pair<Float, String>>)Pair.of(test, (Object)Pair.of((Object)Float.valueOf(factor), (Object)value)));
        }
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    public String getRandomValue(Random random, ConditionContext info) {
        ArrayList<Pair> values = new ArrayList<Pair>();
        for (Pair<Predicate<ConditionContext>, Pair<Float, String>> pair : this.valueSelector) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            values.add((Pair)pair.getRight());
        }
        if (values.isEmpty()) {
            return null;
        }
        Pair randomFromList = Tools.getRandomFromList(random, values, Pair::getLeft);
        if (randomFromList == null) {
            return null;
        }
        return (String)randomFromList.getRight();
    }
}

