/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class CompiledPalette {
    private final Map<Character, Object> palette = new HashMap<Character, Object>();
    private final Map<BlockState, BlockState> damagedToBlock = new HashMap<BlockState, BlockState>();
    private final Map<Character, Palette.Info> information = new HashMap<Character, Palette.Info>();

    public CompiledPalette(CompiledPalette other, Palette ... palettes) {
        this.palette.putAll(other.palette);
        this.damagedToBlock.putAll(other.damagedToBlock);
        this.information.putAll(other.information);
        this.addPalettes(palettes);
    }

    public CompiledPalette(Palette ... palettes) {
        this.addPalettes(palettes);
    }

    private int addEntries(BlockState[] randomBlocks, int idx, BlockState c, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            if (idx >= randomBlocks.length) {
                return idx;
            }
            randomBlocks[idx++] = c;
        }
        return idx;
    }

    private void addPalettes(Palette[] palettes) {
        Palette.PE pe;
        for (Palette p : palettes) {
            if (p == null) continue;
            for (Map.Entry<Character, Palette.PE> entry : p.getPalette().entrySet()) {
                Palette.PE pE = entry.getValue();
                if (pE.blocks() instanceof BlockState) {
                    this.palette.put(entry.getKey(), pE.blocks());
                } else if (pE.blocks() instanceof Pair[]) {
                    Pair pair;
                    Pair[] r = (Pair[])pE.blocks();
                    BlockState[] randomBlocks = new BlockState[128];
                    int idx = 0;
                    Pair[] pairArray = r;
                    int n = pairArray.length;
                    for (int i = 0; i < n && (idx = this.addEntries(randomBlocks, idx, (BlockState)(pair = pairArray[i]).getRight(), (Integer)pair.getLeft())) < randomBlocks.length; ++i) {
                    }
                    this.palette.put(entry.getKey(), randomBlocks);
                } else if (!(pE.blocks() instanceof String)) {
                    if (pE.blocks() == null) {
                        throw new RuntimeException("Invalid palette entry for '" + entry.getKey() + "'!");
                    }
                    this.palette.put(entry.getKey(), pE.blocks());
                }
                this.information.remove(entry.getKey());
            }
        }
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            for (Palette p : palettes) {
                if (p == null) continue;
                for (Map.Entry<Object, Object> entry : p.getPalette().entrySet()) {
                    String blocks;
                    char c;
                    pe = (Palette.PE)entry.getValue();
                    Object idx = pe.blocks();
                    if (!(idx instanceof String) || !this.palette.containsKey(Character.valueOf(c = (blocks = (String)idx).charAt(0))) || this.palette.containsKey(entry.getKey())) continue;
                    this.palette.put((Character)entry.getKey(), this.palette.get(Character.valueOf(c)));
                    this.information.remove(entry.getKey());
                    dirty = true;
                }
            }
        }
        for (Palette p : palettes) {
            if (p == null) continue;
            for (Map.Entry<Object, Object> entry : p.getDamaged().entrySet()) {
                BlockState c = (BlockState)entry.getKey();
                this.damagedToBlock.put(c, (BlockState)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.getPalette().entrySet()) {
                pe = (Palette.PE)entry.getValue();
                if (!pe.info().isSpecial()) continue;
                this.information.put((Character)entry.getKey(), pe.info());
            }
        }
    }

    public Set<Character> getCharacters() {
        return this.palette.keySet();
    }

    public boolean isDefined(Character c) {
        return c != null && this.palette.containsKey(c);
    }

    public boolean isSimple(char c) {
        Object o = this.palette.get(Character.valueOf(c));
        return o instanceof Character;
    }

    public BlockState get(char c, Random rand) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                BlockState state = (BlockState)o;
                return state;
            }
            if (o == null) {
                return null;
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return randomBlocks[rand.nextInt(128)];
        }
        catch (Exception e) {
            LostCities.LOGGER.log(Level.ERROR, (Object)e);
            return null;
        }
    }

    public Set<BlockState> getAll(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                BlockState state = (BlockState)o;
                return Collections.singleton(state);
            }
            if (o == null) {
                return Collections.emptySet();
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return Set.of(randomBlocks);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BlockState get(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                BlockState state = (BlockState)o;
                return state;
            }
            if (o == null) {
                return null;
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return randomBlocks[LostCityTerrainFeature.fastrand128()];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BlockState canBeDamagedToIronBars(BlockState b) {
        return this.damagedToBlock.get(b);
    }

    public Palette.Info getInfo(Character c) {
        return this.information.get(c);
    }

    @Nullable
    public Character find(BlockState state) {
        for (Map.Entry<Character, Object> entry : this.palette.entrySet()) {
            BlockState[] randomBlocks;
            Object o = entry.getValue();
            if (o instanceof BlockState) {
                BlockState s = (BlockState)o;
                if (s != state) continue;
                return entry.getKey();
            }
            for (BlockState randomBlock : randomBlocks = (BlockState[])o) {
                if (randomBlock != state) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public boolean isMatch(char c, BlockState state) {
        BlockState[] randomBlocks;
        Object o = this.palette.get(Character.valueOf(c));
        if (o instanceof BlockState) {
            BlockState s = (BlockState)o;
            return s.m_60734_() == state.m_60734_();
        }
        for (BlockState randomBlock : randomBlocks = (BlockState[])o) {
            if (randomBlock.m_60734_() != state.m_60734_()) continue;
            return true;
        }
        return false;
    }
}

