/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.api.ILostCityInfo;
import mcjty.lostcities.api.ILostCityMultiBuilding;
import mcjty.lostcities.api.ILostExplosion;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.api.LostChunkCharacteristics;
import mcjty.lostcities.api.LostCityEvent;
import mcjty.lostcities.api.MultiPos;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Counter;
import mcjty.lostcities.varia.QualityRandom;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.DamageArea;
import mcjty.lostcities.worldgen.lost.Direction;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Orientation;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Building;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.cityassets.Style;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedStreet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BuildingInfo
implements ILostChunkInfo {
    public final int chunkX;
    public final int chunkZ;
    public final ChunkCoord coord;
    public final IDimensionInfo provider;
    public final LostCityProfile profile;
    public final boolean outsideChunk;
    public int groundLevel;
    public final int waterLevel;
    public final boolean isCity;
    public boolean hasBuilding;
    public final MultiPos multiBuildingPos;
    public final ILostCityMultiBuilding multiBuilding;
    public ILostCityBuilding buildingType;
    public final BuildingPart fountainType;
    public final BuildingPart parkType;
    public final BuildingPart bridgeType;
    public final BuildingPart stairType;
    public final BuildingPart frontType;
    private final float stairPriority;
    public final BuildingPart railDungeon;
    public final StreetType streetType;
    private int floors;
    public int cellars;
    public BuildingPart[] floorTypes;
    public BuildingPart[] floorTypes2;
    public final boolean[] connectionAtX;
    public final boolean[] connectionAtZ;
    public final boolean noLoot;
    public final float ruinHeight;
    public final int highwayXLevel;
    public final int highwayZLevel;
    public final int cityLevel;
    public final boolean xBridge;
    public final boolean zBridge;
    public final boolean xRailCorridor;
    public final boolean zRailCorridor;
    public final Block doorBlock;
    private BuildingInfo xmin = null;
    private BuildingInfo xmax = null;
    private BuildingInfo zmin = null;
    private BuildingInfo zmax = null;
    private DamageArea damageArea = null;
    private Palette palette = null;
    private CompiledPalette compiledPalette = null;
    private Boolean isOcean = null;
    private boolean xBridgeTypeCalculated = false;
    private boolean zBridgeTypeCalculated = false;
    private BuildingPart xBridgeType = null;
    private BuildingPart zBridgeType = null;
    private boolean stairsCalculated = false;
    private Direction stairDirection;
    private boolean actualStairsCalculated = false;
    private Direction actualStairDirection;
    private Boolean horizontalMonorail = null;
    private Boolean verticalMonorail = null;
    private MinMax desiredTerrainCorrectionHeights = null;
    private MinMax desiredMaxHeight1 = null;
    private final List<BlockPos> torchTodo = new ArrayList<BlockPos>();
    private final Map<BlockPos, Runnable> postTodo = new HashMap<BlockPos, Runnable>();
    private static final Map<ChunkCoord, BuildingInfo> BUILDING_INFO_MAP = new HashMap<ChunkCoord, BuildingInfo>();
    private static final Map<ChunkCoord, LostChunkCharacteristics> CITY_INFO_MAP = new HashMap<ChunkCoord, LostChunkCharacteristics>();

    public void addTorchTodo(BlockPos index) {
        this.torchTodo.add(index);
    }

    public List<BlockPos> getTorchTodo() {
        return this.torchTodo;
    }

    public void clearTorchTodo() {
        this.torchTodo.clear();
    }

    public void addPostTodo(BlockPos index, Runnable inf) {
        this.postTodo.put(index, inf);
    }

    public Map<BlockPos, Runnable> getPostTodo() {
        return this.postTodo;
    }

    public void clearPostTodo() {
        this.postTodo.clear();
    }

    public CompiledPalette getCompiledPalette() {
        if (this.compiledPalette == null) {
            Palette buildingPalette;
            this.compiledPalette = new CompiledPalette(this.palette);
            if (this.hasBuilding && (buildingPalette = this.buildingType.getLocalPalette((CommonLevelAccessor)this.provider.getWorld())) != null) {
                this.compiledPalette = new CompiledPalette(this.compiledPalette, buildingPalette);
            }
        }
        return this.compiledPalette;
    }

    public DamageArea getDamageArea() {
        if (this.damageArea == null) {
            this.damageArea = new DamageArea(this.chunkX, this.chunkZ, this.provider, this);
        }
        return this.damageArea;
    }

    public Style getOutsideStyle() {
        return AssetRegistries.STYLES.get((CommonLevelAccessor)this.provider.getWorld(), this.provider.getWorldStyle().getOutsideStyle());
    }

    private void createPalette(Random rand) {
        Style style;
        if (!this.isCity) {
            style = this.getOutsideStyle();
        } else {
            String name = this.getCityStyle().getStyle();
            style = AssetRegistries.STYLES.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), name);
        }
        this.palette = style.getRandomPalette(this.provider, rand);
    }

    public BuildingInfo getXmin() {
        if (this.xmin == null) {
            this.xmin = BuildingInfo.getBuildingInfo(this.chunkX - 1, this.chunkZ, this.provider);
        }
        return this.xmin;
    }

    public BuildingInfo getXmax() {
        if (this.xmax == null) {
            this.xmax = BuildingInfo.getBuildingInfo(this.chunkX + 1, this.chunkZ, this.provider);
        }
        return this.xmax;
    }

    public BuildingInfo getZmin() {
        if (this.zmin == null) {
            this.zmin = BuildingInfo.getBuildingInfo(this.chunkX, this.chunkZ - 1, this.provider);
        }
        return this.zmin;
    }

    public BuildingInfo getZmax() {
        if (this.zmax == null) {
            this.zmax = BuildingInfo.getBuildingInfo(this.chunkX, this.chunkZ + 1, this.provider);
        }
        return this.zmax;
    }

    public int getMaxHeight() {
        if (this.hasBuilding) {
            return this.getCityGroundLevel() + this.floors * 6;
        }
        int m = this.getMaxHighwayLevel();
        if (m >= 0) {
            return this.groundLevel + m * 6;
        }
        return this.getCityGroundLevel();
    }

    public int getCityGroundLevel() {
        return this.groundLevel + this.cityLevel * 6;
    }

    public int getCityGroundLevelOutsideLower() {
        if (this.isCity) {
            return this.groundLevel + this.cityLevel * 6;
        }
        return this.groundLevel + this.cityLevel * 6 - 1;
    }

    public boolean isValidFloor(int l) {
        return l + this.cellars >= 0 && l + this.cellars < this.floorTypes.length;
    }

    public BuildingPart getFloor(int l) {
        return this.floorTypes[l + this.cellars];
    }

    public BuildingPart getFloorPart2(int l) {
        return this.floorTypes2[l + this.cellars];
    }

    public ILostCityBuilding getBuilding() {
        return this.buildingType;
    }

    public CityStyle getCityStyle() {
        return (CityStyle)BuildingInfo.getChunkCharacteristics((ChunkCoord)this.coord, (int)this.chunkX, (int)this.chunkZ, (IDimensionInfo)this.provider).cityStyle;
    }

    public static boolean hasBuildingGui(int chunkX, int chunkZ, IDimensionInfo provider, LostChunkCharacteristics characteristics) {
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.getSeed());
        rand.nextFloat();
        return characteristics.couldHaveBuilding;
    }

    public static synchronized LostChunkCharacteristics getChunkCharacteristicsGui(int chunkX, int chunkZ, IDimensionInfo provider) {
        ResourceKey<Level> type = provider.getType();
        ChunkCoord key = new ChunkCoord(type, chunkX, chunkZ);
        if (CITY_INFO_MAP.containsKey(key)) {
            return CITY_INFO_MAP.get(key);
        }
        LostCityProfile profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
        LostChunkCharacteristics characteristics = new LostChunkCharacteristics();
        characteristics.isCity = BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile);
        characteristics.cityLevel = BuildingInfo.getCityLevel(chunkX, chunkZ, provider);
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.getSeed());
        characteristics.couldHaveBuilding = characteristics.isCity && rand.nextFloat() < profile.BUILDING_CHANCE;
        CITY_INFO_MAP.put(key, characteristics);
        return characteristics;
    }

    public static LostChunkCharacteristics getChunkCharacteristics(int chunkX, int chunkZ, IDimensionInfo provider) {
        return BuildingInfo.getChunkCharacteristics(new ChunkCoord(provider.dimension(), chunkX, chunkZ), chunkX, chunkZ, provider);
    }

    public static synchronized LostChunkCharacteristics getChunkCharacteristics(ChunkCoord key, int chunkX, int chunkZ, IDimensionInfo provider) {
        CityStyle cityStyle;
        float dist;
        ResourceKey<Level> type = provider.getType();
        if (CITY_INFO_MAP.containsKey(key)) {
            return CITY_INFO_MAP.get(key);
        }
        LostCityProfile profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
        LostChunkCharacteristics characteristics = new LostChunkCharacteristics();
        characteristics.isCity = BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile);
        BuildingInfo.initMultiBuildingSection(characteristics, chunkX, chunkZ, provider, profile);
        characteristics.cityLevel = characteristics.multiPos.isSingle() ? BuildingInfo.getCityLevel(chunkX, chunkZ, provider) : BuildingInfo.getAverageCityLevel(characteristics, chunkX, chunkZ, provider);
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.getSeed());
        boolean bl = characteristics.couldHaveBuilding = characteristics.isCity && BuildingInfo.checkBuildingPossibility(chunkX, chunkZ, provider, profile, characteristics.multiPos, characteristics.cityLevel, rand);
        if ((profile.isSpace() || profile.isSpheres()) && characteristics.multiPos.isSingle() && (dist = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider)) > 0.7f) {
            characteristics.couldHaveBuilding = false;
        }
        if (characteristics.isCity && !characteristics.couldHaveBuilding) {
            Counter<String> counter = new Counter<String>();
            for (int cx = -1; cx <= 1; ++cx) {
                for (int cz = -1; cz <= 1; ++cz) {
                    CityStyle cityStyle2 = City.getCityStyle(key.chunkX() + cx, key.chunkZ() + cz, provider, profile);
                    counter.add(cityStyle2.getName());
                    if (cx != 0 || cz != 0) continue;
                    counter.add(cityStyle2.getName());
                }
            }
            cityStyle = AssetRegistries.CITYSTYLES.get((CommonLevelAccessor)provider.getWorld(), (String)counter.getMostOccuring());
        } else {
            cityStyle = City.getCityStyle(chunkX, chunkZ, provider, profile);
        }
        characteristics.cityStyle = cityStyle;
        WorldGenLevel world = provider.getWorld();
        if (characteristics.multiPos.isMulti() && !characteristics.multiPos.isTopLeft()) {
            LostChunkCharacteristics topleft = BuildingInfo.getTopLeftCityInfo(characteristics, chunkX, chunkZ, provider);
            if (characteristics.multiBuilding != null) {
                String b = characteristics.multiBuilding.getBuilding(characteristics.multiPos.x(), characteristics.multiPos.z());
                characteristics.buildingType = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)world, b);
            } else {
                characteristics.buildingType = topleft.buildingType;
                if (characteristics.buildingType == null) {
                    throw new RuntimeException("Topleft building type is not set!");
                }
            }
        } else {
            PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
            if (characteristics.multiPos.isTopLeft()) {
                String b = characteristics.multiBuilding.getBuilding(0, 0);
                characteristics.buildingType = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)world, b);
            } else {
                String name = cityStyle.getRandomBuilding(rand);
                if (predefinedBuilding != null) {
                    name = predefinedBuilding.building();
                }
                characteristics.buildingType = AssetRegistries.BUILDINGS.getOrThrow((CommonLevelAccessor)world, name);
            }
        }
        LostCityEvent.CharacteristicsEvent event = new LostCityEvent.CharacteristicsEvent(world, LostCities.lostCitiesImp, chunkX, chunkZ, characteristics);
        MinecraftForge.EVENT_BUS.post((Event)event);
        CITY_INFO_MAP.put(key, characteristics);
        return characteristics;
    }

    public static boolean isCityRaw(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        float cityFactor;
        if (BuildingInfo.isVoidChunk(chunkX, chunkZ, provider)) {
            return false;
        }
        if (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) {
            if (CitySphere.onCitySphereBorder(chunkX, chunkZ, provider)) {
                return false;
            }
            if (CitySphere.hasMonorailStation(chunkX, chunkZ, provider)) {
                return false;
            }
        }
        return (cityFactor = City.getCityFactor(chunkX, chunkZ, provider, profile)) > profile.CITY_THRESHOLD;
    }

    public static boolean isCity(int chunkX, int chunkZ, IDimensionInfo provider) {
        return BuildingInfo.getChunkCharacteristics((ChunkCoord)new ChunkCoord(provider.dimension(), (int)chunkX, (int)chunkZ), (int)chunkX, (int)chunkZ, (IDimensionInfo)provider).isCity;
    }

    private static boolean checkBuildingPossibility(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile, MultiPos section, int cityLevel, Random rand) {
        int maxh;
        Railway.RailChunkInfo info;
        int maxh2;
        float bc = rand.nextFloat();
        ResourceKey<Level> type = provider.getType();
        PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
        if (predefinedBuilding != null) {
            return true;
        }
        PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, type);
        if (predefinedStreet != null) {
            return false;
        }
        CityStyle style = City.getCityStyle(chunkX, chunkZ, provider, profile);
        float buildingChance = profile.BUILDING_CHANCE;
        if (style.getBuildingChance() != null) {
            buildingChance = style.getBuildingChance().floatValue();
        }
        boolean b = section.isMulti() ? true : (bc >= buildingChance ? false : (BuildingInfo.hasHighway(chunkX, chunkZ, provider, profile) ? cityLevel > (maxh2 = Math.max(Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile), Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile))) + 1 : (BuildingInfo.hasRailway(chunkX, chunkZ, provider, profile) ? ((info = Railway.getRailChunkType(chunkX, chunkZ, provider, profile)).getType() == RailChunkType.STATION_UNDERGROUND ? false : cityLevel > (maxh = info.getLevel()) + 1) : true)));
        return b;
    }

    private static void initMultiBuildingSection(LostChunkCharacteristics characteristics, int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        for (int x = -2; x <= 0; ++x) {
            for (int z = -2; z <= 0; ++z) {
                MultiBuilding building = BuildingInfo.isTopLeftOfMultiBuilding(chunkX + x, chunkZ + z, provider, profile);
                if (building == null || building.getDimX() <= -x || building.getDimZ() <= -z) continue;
                characteristics.multiPos = new MultiPos(-x, -z, building.getDimX(), building.getDimZ());
                characteristics.multiBuilding = building;
                return;
            }
        }
        characteristics.multiPos = MultiPos.SINGLE;
        characteristics.multiBuilding = null;
    }

    private BuildingInfo calculateTopLeft() {
        if (this.multiBuildingPos.isTopLeft()) {
            return this;
        }
        return BuildingInfo.getBuildingInfo(this.chunkX - this.multiBuildingPos.x(), this.chunkZ - this.multiBuildingPos.z(), this.provider);
    }

    private static int getAverageCityLevel(LostChunkCharacteristics thisone, int chunkX, int chunkZ, IDimensionInfo provider) {
        LostChunkCharacteristics topleft = BuildingInfo.getTopLeftCityInfo(thisone, chunkX, chunkZ, provider);
        int level = 0;
        MultiPos mp = topleft.multiPos;
        int topX = chunkX - mp.x();
        int topZ = chunkZ - mp.z();
        for (int x = 0; x < mp.w(); ++x) {
            for (int z = 0; z < mp.h(); ++z) {
                level += BuildingInfo.getCityLevel(topX + x, topZ + z, provider);
            }
        }
        return level / (mp.w() * mp.h());
    }

    private static LostChunkCharacteristics getTopLeftCityInfo(LostChunkCharacteristics thisone, int chunkX, int chunkZ, IDimensionInfo provider) {
        if (thisone.multiPos.isTopLeft()) {
            return thisone;
        }
        int cx = chunkX - thisone.multiPos.x();
        int cz = chunkZ - thisone.multiPos.z();
        return BuildingInfo.getChunkCharacteristics(cx, cz, provider);
    }

    private static boolean isCandidateForTopLeftOfMultiBuilding(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile, CityStyle cityStyle) {
        ResourceKey<Level> type = provider.getType();
        PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return true;
        }
        PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, type);
        if (predefinedStreet != null) {
            return false;
        }
        if (BuildingInfo.isMultiBuildingCandidate(chunkX, chunkZ, provider, profile, cityStyle)) {
            Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.getSeed());
            return rand.nextFloat() < profile.BUILDING2X2_CHANCE;
        }
        return false;
    }

    private static boolean isMultiBuildingCandidate(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile, CityStyle cityStyle) {
        boolean result;
        boolean bl = result = BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile) && !BuildingInfo.hasHighway(chunkX, chunkZ, provider, profile) && !BuildingInfo.hasRailway(chunkX, chunkZ, provider, profile);
        if (result) {
            CityStyle style = City.getCityStyle(chunkX, chunkZ, provider, profile);
            if (!cityStyle.hasMultiBuildings()) {
                return false;
            }
            return style.getName().equals(cityStyle.getName());
        }
        return false;
    }

    private static boolean hasHighway(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile) >= 0 || Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile) >= 0;
    }

    private static boolean hasRailway(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Railway.getRailChunkType(chunkX, chunkZ, provider, profile).getType() != RailChunkType.NONE;
    }

    public Railway.RailChunkInfo getRailInfo() {
        return Railway.getRailChunkType(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public boolean isTunnel(int level) {
        if (this.isCity) {
            return this.cityLevel > level;
        }
        ChunkHeightmap heightmap = this.provider.getHeightmap(this.chunkX, this.chunkZ);
        int highwayHeight = this.groundLevel + level * 6 + 3;
        int cnt = 0;
        for (int x = 2; x < 16; x += 3) {
            for (int z = 2; z < 16; z += 3) {
                if (heightmap.getHeight(x, z) <= highwayHeight) continue;
                ++cnt;
            }
        }
        return cnt > 12;
    }

    @Nullable
    private static MultiBuilding isTopLeftOfMultiBuilding(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        ResourceKey<Level> type = provider.getType();
        PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
        if (predefinedBuilding != null && predefinedBuilding.multi()) {
            return AssetRegistries.MULTI_BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), predefinedBuilding.building());
        }
        CityStyle cityStyle = City.getCityStyle(chunkX, chunkZ, provider, profile);
        if (!cityStyle.hasMultiBuildings()) {
            return null;
        }
        Random rand = BuildingInfo.getMultiBuildingRandom(chunkX, chunkZ, provider.getSeed());
        String name = cityStyle.getRandomMultiBuilding(rand);
        if (name == null) {
            return null;
        }
        MultiBuilding building = AssetRegistries.MULTI_BUILDINGS.getOrThrow((CommonLevelAccessor)provider.getWorld(), name);
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                CityStyle otherStyle;
                if (x == 0 && z == 0 && !BuildingInfo.isCandidateForTopLeftOfMultiBuilding(chunkX, chunkZ, provider, profile, cityStyle)) {
                    return null;
                }
                if (x >= 0 && z >= 0 || !BuildingInfo.isCandidateForTopLeftOfMultiBuilding(chunkX + x, chunkZ + z, provider, profile, otherStyle = City.getCityStyle(chunkX + x, chunkZ + z, provider, profile))) continue;
                return null;
            }
        }
        PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, type);
        if (predefinedStreet != null) {
            return null;
        }
        for (int x = 0; x < building.getDimX(); ++x) {
            for (int z = 0; z < building.getDimZ(); ++z) {
                if (x == 0 && z == 0 || BuildingInfo.isMultiBuildingCandidate(chunkX + x, chunkZ + z, provider, profile, cityStyle)) continue;
                return null;
            }
        }
        return building;
    }

    public static void cleanCache() {
        BUILDING_INFO_MAP.clear();
        CITY_INFO_MAP.clear();
    }

    public static synchronized BuildingInfo getBuildingInfo(int chunkX, int chunkZ, IDimensionInfo provider) {
        ChunkCoord key = new ChunkCoord(provider.getType(), chunkX, chunkZ);
        if (BUILDING_INFO_MAP.containsKey(key)) {
            return BUILDING_INFO_MAP.get(key);
        }
        BuildingInfo info = new BuildingInfo(key, chunkX, chunkZ, provider);
        BUILDING_INFO_MAP.put(key, info);
        return info;
    }

    public static LostCityProfile getProfile(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) {
            if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                return provider.getProfile();
            }
            return provider.getOutsideProfile();
        }
        return provider.getProfile();
    }

    public void setBuildingType(Building building, int cellars, int floors, int groundLevel) {
        this.buildingType = building;
        this.hasBuilding = true;
        this.floors = floors;
        this.cellars = cellars;
        this.groundLevel = groundLevel;
        this.floorTypes = new BuildingPart[floors + cellars + 1];
        this.floorTypes2 = new BuildingPart[floors + cellars + 1];
        Random rand = BuildingInfo.getBuildingRandom(this.chunkX, this.chunkZ, this.provider.getSeed());
        rand.nextFloat();
        for (int i = 0; i <= floors + cellars; ++i) {
            ConditionContext conditionContext = new ConditionContext(this.cityLevel + i - cellars, i - cellars, cellars, floors, "<none>", building.getName(), this.chunkX, this.chunkZ){

                @Override
                public boolean isBuilding() {
                    return true;
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(BuildingInfo.this.chunkX, BuildingInfo.this.chunkZ, new BlockPos(BuildingInfo.this.chunkX * 16 + 8, 0, BuildingInfo.this.chunkZ * 16 + 8), BuildingInfo.this.provider);
                }

                @Override
                public ResourceLocation getBiome() {
                    return ((Biome)BuildingInfo.this.provider.getWorld().m_204166_(new BlockPos(BuildingInfo.this.chunkX * 16 + 8, 0, BuildingInfo.this.chunkZ * 16 + 8)).m_203334_()).getRegistryName();
                }
            };
            String randomPart = building.getRandomPart(rand, conditionContext);
            this.floorTypes[i] = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)this.provider.getWorld(), randomPart);
            randomPart = building.getRandomPart2(rand, conditionContext);
            this.floorTypes2[i] = AssetRegistries.PARTS.get((CommonLevelAccessor)this.provider.getWorld(), randomPart);
        }
    }

    private BuildingInfo(ChunkCoord key, final int chunkX, final int chunkZ, final IDimensionInfo provider) {
        int wl;
        this.provider = provider;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        ResourceKey<Level> type = provider.getType();
        this.coord = key;
        this.outsideChunk = (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && !CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider);
        this.profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
        LostChunkCharacteristics characteristics = BuildingInfo.getChunkCharacteristics(key, chunkX, chunkZ, provider);
        this.isCity = characteristics.isCity;
        this.cityLevel = characteristics.cityLevel;
        this.buildingType = characteristics.buildingType;
        this.multiBuilding = characteristics.multiBuilding;
        this.multiBuildingPos = characteristics.multiPos;
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.getSeed());
        rand.nextFloat();
        boolean b = characteristics.couldHaveBuilding;
        if (b && this.multiBuildingPos.isSingle()) {
            if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)(chunkX - 1), (int)chunkZ, (IDimensionInfo)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)(chunkX + 1), (int)chunkZ, (IDimensionInfo)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)chunkX, (int)(chunkZ - 1), (IDimensionInfo)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)chunkX, (int)(chunkZ + 1), (IDimensionInfo)provider).buildingType.getPrefersLonely()) {
                b = false;
            }
        }
        this.hasBuilding = b;
        if (this.outsideChunk) {
            this.groundLevel = provider.getOutsideProfile().GROUNDLEVEL;
            wl = provider.getOutsideProfile().SEALEVEL;
        } else {
            this.groundLevel = provider.getProfile().GROUNDLEVEL;
            wl = provider.getProfile().SEALEVEL;
        }
        this.waterLevel = wl == -1 ? Tools.getSeaLevel((LevelReader)provider.getWorld()) : wl;
        CityStyle cs = (CityStyle)characteristics.cityStyle;
        if (this.multiBuildingPos.isMulti() && !this.multiBuildingPos.isTopLeft()) {
            BuildingInfo topleft = this.calculateTopLeft();
            this.highwayXLevel = topleft.highwayXLevel;
            this.highwayZLevel = topleft.highwayZLevel;
            this.streetType = topleft.streetType;
            this.fountainType = topleft.fountainType;
            this.parkType = topleft.parkType;
            this.floors = topleft.floors;
            this.cellars = topleft.cellars;
            this.doorBlock = topleft.doorBlock;
            this.bridgeType = topleft.bridgeType;
            this.stairType = topleft.stairType;
            this.stairPriority = topleft.stairPriority;
            this.palette = topleft.palette;
            this.compiledPalette = topleft.getCompiledPalette();
            this.noLoot = topleft.noLoot;
            this.ruinHeight = topleft.ruinHeight;
        } else {
            int minfloors;
            PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
            this.highwayXLevel = Highway.getXHighwayLevel(chunkX, chunkZ, provider, this.profile);
            this.highwayZLevel = Highway.getZHighwayLevel(chunkX, chunkZ, provider, this.profile);
            this.streetType = rand.nextDouble() < (double)this.profile.PARK_CHANCE ? StreetType.values()[rand.nextInt(StreetType.values().length)] : StreetType.NORMAL;
            this.fountainType = rand.nextFloat() < this.profile.FOUNTAIN_CHANCE ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), cs.getRandomFountain(rand)) : null;
            this.parkType = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), cs.getRandomPark(rand));
            float cityFactor = City.getCityFactor(chunkX, chunkZ, provider, this.profile);
            int maxfloors = this.getMaxfloors(cs);
            int f = this.profile.BUILDING_MINFLOORS + rand.nextInt((int)((float)this.profile.BUILDING_MINFLOORS_CHANCE + (cityFactor + 0.1f) * (float)(this.profile.BUILDING_MAXFLOORS_CHANCE - this.profile.BUILDING_MINFLOORS_CHANCE)));
            if (++f > maxfloors + 1) {
                f = maxfloors + 1;
            }
            if (f < (minfloors = this.getMinfloors(cs))) {
                f = minfloors;
            }
            if ((provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                float reldest = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider);
                if (reldest > 0.6f) {
                    f = Math.max(minfloors, f - 2);
                } else if (reldest > 0.5f) {
                    f = Math.max(minfloors, f - 1);
                }
            }
            this.floors = f;
            int maxcellars = this.getMaxcellars(cs);
            int fb = this.profile.BUILDING_MINCELLARS + (maxcellars <= 0 ? 0 : rand.nextInt(maxcellars + 1));
            if (this.getMaxHighwayLevel() >= 0 && (fb = Math.min(this.cityLevel - this.getMaxHighwayLevel() - 1, fb)) < 0) {
                fb = 0;
            }
            this.cellars = fb;
            this.doorBlock = this.getRandomDoor(rand);
            this.bridgeType = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), cs.getRandomBridge(rand));
            this.stairType = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), cs.getRandomStair(rand));
            this.stairPriority = rand.nextFloat();
            this.createPalette(rand);
            float r = rand.nextFloat();
            this.noLoot = this.multiBuildingPos.isSingle() && r < this.profile.BUILDING_WITHOUT_LOOT_CHANCE;
            r = rand.nextFloat();
            this.ruinHeight = rand.nextFloat() < this.profile.RUIN_CHANCE && (predefinedBuilding == null || !predefinedBuilding.preventRuins()) ? this.profile.RUIN_MINLEVEL_PERCENT + (this.profile.RUIN_MAXLEVEL_PERCENT - this.profile.RUIN_MINLEVEL_PERCENT) * r : -1.0f;
        }
        this.floorTypes = new BuildingPart[this.floors + this.cellars + 1];
        this.floorTypes2 = new BuildingPart[this.floors + this.cellars + 1];
        this.connectionAtX = new boolean[this.floors + this.cellars + 1];
        this.connectionAtZ = new boolean[this.floors + this.cellars + 1];
        Building building = (Building)this.getBuilding();
        for (int i = 0; i <= this.floors + this.cellars; ++i) {
            ConditionContext conditionContext = new ConditionContext(this.cityLevel + i - this.cellars, i - this.cellars, this.cellars, this.floors, "<none>", building.getName(), chunkX, chunkZ){

                @Override
                public boolean isBuilding() {
                    return true;
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(chunkX, chunkZ, new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8), provider);
                }

                @Override
                public ResourceLocation getBiome() {
                    return ((Biome)provider.getWorld().m_204166_(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)).m_203334_()).getRegistryName();
                }
            };
            String randomPart = building.getRandomPart(rand, conditionContext);
            this.floorTypes[i] = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), randomPart);
            randomPart = building.getRandomPart2(rand, conditionContext);
            this.floorTypes2[i] = AssetRegistries.PARTS.get((CommonLevelAccessor)provider.getWorld(), randomPart);
            this.connectionAtX[i] = BuildingInfo.isCity(chunkX - 1, chunkZ, provider) && rand.nextFloat() < this.profile.BUILDING_DOORWAYCHANCE;
            this.connectionAtZ[i] = BuildingInfo.isCity(chunkX, chunkZ - 1, provider) && rand.nextFloat() < this.profile.BUILDING_DOORWAYCHANCE;
        }
        if (this.hasBuilding && this.cellars > 0) {
            this.xRailCorridor = false;
            this.zRailCorridor = false;
        } else {
            this.xRailCorridor = rand.nextFloat() < this.profile.CORRIDOR_CHANCE;
            boolean bl = this.zRailCorridor = rand.nextFloat() < this.profile.CORRIDOR_CHANCE;
        }
        if (this.isCity) {
            this.xBridge = false;
            this.zBridge = false;
        } else {
            this.xBridge = rand.nextFloat() < this.profile.BRIDGE_CHANCE;
            boolean bl = this.zBridge = rand.nextFloat() < this.profile.BRIDGE_CHANCE;
        }
        this.railDungeon = rand.nextFloat() < this.profile.RAILWAY_DUNGEON_CHANCE ? (!this.hasBuilding || -3 < this.cityLevel - this.cellars ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), this.getCityStyle().getRandomRailDungeon(rand)) : null) : null;
        this.frontType = rand.nextFloat() < this.profile.BUILDING_FRONTCHANCE ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), this.getCityStyle().getRandomFront(rand)) : null;
    }

    public boolean hasHorizontalMonorail() {
        if (this.horizontalMonorail == null) {
            this.horizontalMonorail = CitySphere.hasHorizontalMonorail(this.chunkX, this.chunkZ, this.provider);
        }
        return this.horizontalMonorail;
    }

    public boolean hasVerticalMonorail() {
        if (this.verticalMonorail == null) {
            this.verticalMonorail = CitySphere.hasVerticalMonorail(this.chunkX, this.chunkZ, this.provider);
        }
        return this.verticalMonorail;
    }

    public boolean hasMonorail() {
        return this.hasHorizontalMonorail() || this.hasVerticalMonorail();
    }

    private int getMaxcellars(CityStyle cs) {
        int maxcellars = this.profile.BUILDING_MAXCELLARS + this.cityLevel;
        if (this.buildingType.getMaxCellars() != -1) {
            maxcellars = Math.min(maxcellars, this.buildingType.getMaxCellars());
        }
        if (this.buildingType.getMinCellars() != -1) {
            maxcellars = Math.max(maxcellars, this.buildingType.getMinCellars());
        }
        if (cs.getMaxCellarCount() != null) {
            maxcellars = Math.min(maxcellars, cs.getMaxCellarCount());
        }
        if (cs.getMinCellarCount() != null) {
            maxcellars = Math.max(maxcellars, cs.getMinCellarCount());
        }
        return maxcellars;
    }

    private int getMinfloors(CityStyle cs) {
        int minfloors = this.profile.BUILDING_MINFLOORS + 1;
        if (this.buildingType.getMinFloors() != -1) {
            minfloors = Math.max(minfloors, this.buildingType.getMinFloors());
        }
        if (cs.getMinFloorCount() != null) {
            minfloors = Math.max(minfloors, cs.getMinFloorCount());
        }
        return minfloors;
    }

    private int getMaxfloors(CityStyle cs) {
        int maxfloors = this.profile.BUILDING_MAXFLOORS;
        if (this.buildingType.getMaxFloors() != -1) {
            maxfloors = Math.min(maxfloors, this.buildingType.getMaxFloors());
        }
        if (cs.getMaxFloorCount() != null) {
            maxfloors = Math.min(maxfloors, cs.getMaxFloorCount());
        }
        return maxfloors;
    }

    public int getHighwayXLevel() {
        return Highway.getXHighwayLevel(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public int getHighwayZLevel() {
        return Highway.getZHighwayLevel(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public static boolean isVoidChunk(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (provider.getProfile().isFloating()) {
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(8, 8) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(3, 3) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(12, 3) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(3, 12) <= 0) {
                return true;
            }
            return provider.getHeightmap(chunkX, chunkZ).getHeight(12, 12) <= 0;
        }
        return false;
    }

    public static int getCityLevel(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (provider.getProfile().isSpace() || provider.getProfile().isSpheres()) {
            return BuildingInfo.getCityLevelSpace(chunkX, chunkZ, provider);
        }
        if (provider.getProfile().isFloating()) {
            return BuildingInfo.getCityLevelFloating(chunkX, chunkZ, provider);
        }
        if (provider.getProfile().isCavern()) {
            return BuildingInfo.getCityLevelCavern(chunkX, chunkZ, provider);
        }
        return BuildingInfo.getCityLevelNormal(chunkX, chunkZ, provider, provider.getProfile());
    }

    private static int getCityLevelCavern(int chunkX, int chunkZ, IDimensionInfo provider) {
        return BuildingInfo.getCityLevelFloating(chunkX, chunkZ, provider);
    }

    private static int getCityLevelSpace(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
            float dist = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider);
            Random rand = new Random(provider.getSeed() + (long)chunkZ * 817505771L + (long)chunkX * 217645177L);
            rand.nextFloat();
            rand.nextFloat();
            if (dist < 0.3f) {
                return 2 + rand.nextInt(2);
            }
            if (dist < 0.4f) {
                return 1 + rand.nextInt(2);
            }
            if (dist < 0.6f) {
                return rand.nextInt(2);
            }
            return 0;
        }
        return BuildingInfo.getCityLevelNormal(chunkX, chunkZ, provider, provider.getOutsideProfile());
    }

    private static int getCityLevelNormal(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        ChunkHeightmap heightmap = provider.getHeightmap(chunkX, chunkZ);
        int height = heightmap.getAverageHeight();
        return BuildingInfo.getLevelBasedOnHeight(height, profile);
    }

    private static int getCityLevelFloating(int chunkX, int chunkZ, IDimensionInfo provider) {
        int h4;
        int h3;
        int h2;
        int h1;
        int cnt = 0;
        int h = 0;
        int h0 = provider.getHeightmap(chunkX, chunkZ).getHeight(8, 8);
        if (h0 > 1) {
            h += h0;
            ++cnt;
        }
        if ((h1 = provider.getHeightmap(chunkX, chunkZ).getHeight(3, 3)) > 1) {
            h += h1;
            ++cnt;
        }
        if ((h2 = provider.getHeightmap(chunkX, chunkZ).getHeight(12, 3)) > 1) {
            h += h2;
            ++cnt;
        }
        if ((h3 = provider.getHeightmap(chunkX, chunkZ).getHeight(3, 12)) > 1) {
            h += h3;
            ++cnt;
        }
        if ((h4 = provider.getHeightmap(chunkX, chunkZ).getHeight(12, 12)) > 1) {
            h += h4;
            ++cnt;
        }
        if (cnt > 0) {
            h /= cnt;
        }
        return BuildingInfo.getLevelBasedOnHeight(h, provider.getProfile());
    }

    private static int getLevelBasedOnHeight(int height, LostCityProfile profile) {
        if (height < profile.CITY_LEVEL0_HEIGHT) {
            return 0;
        }
        if (height < profile.CITY_LEVEL1_HEIGHT) {
            return 1;
        }
        if (height < profile.CITY_LEVEL2_HEIGHT) {
            return 2;
        }
        if (height < profile.CITY_LEVEL3_HEIGHT) {
            return 3;
        }
        return 4;
    }

    private Block getRandomDoor(Random rand) {
        return switch (rand.nextInt(7)) {
            case 0 -> Blocks.f_50485_;
            case 1 -> Blocks.f_50487_;
            case 2 -> Blocks.f_50488_;
            case 3 -> Blocks.f_50484_;
            case 4 -> Blocks.f_50154_;
            case 5 -> Blocks.f_50486_;
            case 6 -> Blocks.f_50166_;
            default -> Blocks.f_50154_;
        };
    }

    public boolean isStreetSection() {
        return this.isCity && !this.hasBuilding;
    }

    public boolean isElevatedParkSection() {
        if (!this.isStreetSection()) {
            return false;
        }
        if (!this.getXmin().isStreetSection()) {
            return false;
        }
        if (!this.getXmax().isStreetSection()) {
            return false;
        }
        if (!this.getZmin().isStreetSection()) {
            return false;
        }
        if (!this.getZmax().isStreetSection()) {
            return false;
        }
        int cnt = 0;
        cnt += this.getXmin().getZmin().isStreetSection() ? 1 : 0;
        cnt += this.getXmin().getZmax().isStreetSection() ? 1 : 0;
        cnt += this.getXmax().getZmin().isStreetSection() ? 1 : 0;
        return (cnt += this.getXmax().getZmax().isStreetSection() ? 1 : 0) >= 3;
    }

    private Direction getStairDirection() {
        if (!this.stairsCalculated) {
            this.stairsCalculated = true;
            this.stairDirection = this.streetType != StreetType.PARK && !this.hasBuilding && this.isCity ? (this.cityLevel == this.getXmin().cityLevel - 1 && !this.getXmin().hasBuilding && this.getXmin().isCity ? Direction.XMIN : (this.cityLevel == this.getXmax().cityLevel - 1 && !this.getXmax().hasBuilding && this.getXmax().isCity ? Direction.XMAX : (this.cityLevel == this.getZmin().cityLevel - 1 && !this.getZmin().hasBuilding && this.getZmin().isCity ? Direction.ZMIN : (this.cityLevel == this.getZmax().cityLevel - 1 && !this.getZmax().hasBuilding && this.getZmax().isCity ? Direction.ZMAX : null)))) : null;
        }
        return this.stairDirection;
    }

    public Direction getActualStairDirection() {
        if (!this.actualStairsCalculated) {
            this.actualStairsCalculated = true;
            this.actualStairDirection = this.getStairDirection();
            if (this.actualStairDirection != null) {
                block0: for (int cx = -1; cx <= 1; ++cx) {
                    for (int cz = -1; cz <= 1; ++cz) {
                        BuildingInfo adjacent;
                        if (cx == 0 && cz == 0 || (adjacent = BuildingInfo.getBuildingInfo(this.chunkX + cx, this.chunkZ + cz, this.provider)).getStairDirection() == null || !(adjacent.stairPriority > this.stairPriority)) continue;
                        this.actualStairDirection = null;
                        continue block0;
                    }
                }
            }
        }
        return this.actualStairDirection;
    }

    public BuildingPart hasBridge(IDimensionInfo provider, Orientation orientation) {
        return switch (orientation) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X -> this.hasXBridge(provider);
            case Orientation.Z -> this.hasZBridge(provider);
        };
    }

    public boolean hasBridge(IDimensionInfo provider) {
        if (this.hasXBridge(provider) != null) {
            return true;
        }
        return this.hasZBridge(provider) != null;
    }

    public BuildingPart hasXBridge(IDimensionInfo provider) {
        if (this.xBridgeTypeCalculated) {
            return this.xBridgeType;
        }
        this.xBridgeTypeCalculated = true;
        this.xBridgeType = null;
        if (!this.xBridge) {
            return null;
        }
        if (!this.isSuitableForBridge(provider, this)) {
            return null;
        }
        if (this.chunkZ % 2 != 0 && (this.getZmin().hasXBridge(provider) != null || this.getZmax().hasXBridge(provider) != null)) {
            return null;
        }
        BuildingPart bt = this.bridgeType;
        BuildingInfo i = this.getXmin();
        while (!i.isCity && i.xBridge && this.isSuitableForBridge(provider, i)) {
            if (this.chunkZ % 2 != 0 && (i.getZmin().hasXBridge(provider) != null || i.getZmax().hasXBridge(provider) != null)) {
                return null;
            }
            bt = i.bridgeType;
            i = i.getXmin();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        BuildingInfo minimum = i;
        i = this.getXmax();
        while (!i.isCity && i.xBridge && this.isSuitableForBridge(provider, i)) {
            if (this.chunkZ % 2 != 0 && (i.getZmin().hasXBridge(provider) != null || i.getZmax().hasXBridge(provider) != null)) {
                return null;
            }
            i = i.getXmax();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        this.xBridgeType = bt;
        for (i = i.getXmin(); i != minimum; i = i.getXmin()) {
            i.xBridgeType = bt;
            i.xBridgeTypeCalculated = true;
            i.zBridgeType = null;
            i.zBridgeTypeCalculated = true;
        }
        return bt;
    }

    public BuildingPart hasZBridge(IDimensionInfo provider) {
        if (this.zBridgeTypeCalculated) {
            return this.zBridgeType;
        }
        this.zBridgeTypeCalculated = true;
        this.zBridgeType = null;
        if (!this.zBridge) {
            return null;
        }
        if (!this.isSuitableForBridge(provider, this)) {
            return null;
        }
        if (this.hasXBridge(provider) != null) {
            return null;
        }
        if (this.chunkX % 2 != 0 && (this.getXmin().hasZBridge(provider) != null || this.getXmax().hasZBridge(provider) != null)) {
            return null;
        }
        BuildingPart bt = this.bridgeType;
        BuildingInfo i = this.getZmin();
        while (!i.isCity && i.zBridge && this.isSuitableForBridge(provider, i)) {
            if (i.hasXBridge(provider) != null) {
                return null;
            }
            if (this.chunkX % 2 != 0 && (i.getXmin().hasZBridge(provider) != null || i.getXmax().hasZBridge(provider) != null)) {
                return null;
            }
            bt = i.bridgeType;
            i = i.getZmin();
        }
        BuildingInfo minimum = i;
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        i = this.getZmax();
        while (!i.isCity && i.zBridge && this.isSuitableForBridge(provider, i)) {
            if (i.hasXBridge(provider) != null) {
                return null;
            }
            if (this.chunkX % 2 != 0 && (i.getXmin().hasZBridge(provider) != null || i.getXmax().hasZBridge(provider) != null)) {
                return null;
            }
            i = i.getZmax();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        this.zBridgeType = bt;
        for (i = i.getZmin(); i != minimum; i = i.getZmin()) {
            i.zBridgeType = bt;
            i.zBridgeTypeCalculated = true;
            i.xBridgeType = null;
            i.xBridgeTypeCalculated = true;
        }
        return bt;
    }

    public boolean isOcean() {
        if (this.isOcean != null) {
            return this.isOcean;
        }
        Holder<Biome> mainBiome = BiomeInfo.getBiomeInfo(this.provider, this.coord).getMainBiome();
        this.isOcean = mainBiome.m_203656_(BiomeTags.f_207603_) || mainBiome.m_203656_(BiomeTags.f_207602_);
        return this.isOcean;
    }

    private boolean isSuitableForBridge(IDimensionInfo provider, BuildingInfo i) {
        if (provider.getProfile().isSpace() && this.hasMonorail()) {
            return false;
        }
        return i.cityLevel < this.cityLevel || LostCityTerrainFeature.isWaterBiome(provider, i.coord);
    }

    public boolean hasXCorridor() {
        if (!this.xRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getXmin();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmin();
        }
        if (!i.hasBuilding || i.cellars == 0) {
            return false;
        }
        i = this.getXmax();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmax();
        }
        return i.hasBuilding && i.cellars != 0;
    }

    public boolean hasZCorridor() {
        if (!this.zRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getZmin();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmin();
        }
        if (!i.hasBuilding || i.cellars == 0) {
            return false;
        }
        i = this.getZmax();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmax();
        }
        return i.hasBuilding && i.cellars != 0;
    }

    public boolean canRailGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.cellars == 0;
    }

    public boolean canWaterCorridorGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.cellars <= 1;
    }

    public boolean doesRoadExtendTo() {
        boolean b;
        boolean bl = b = this.isCity && !this.hasBuilding;
        if (b) {
            return !this.isElevatedParkSection();
        }
        return false;
    }

    public static boolean hasRoadConnection(BuildingInfo i1, BuildingInfo i2) {
        if (!i1.doesRoadExtendTo()) {
            return false;
        }
        if (!i2.doesRoadExtendTo()) {
            return false;
        }
        return Math.abs(i1.cityLevel - i2.cityLevel) <= 0;
    }

    public static Random getBuildingRandom(int chunkX, int chunkZ, long seed) {
        QualityRandom random = new QualityRandom(seed + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        random.nextFloat();
        random.nextFloat();
        return random;
    }

    public static Random getMultiBuildingRandom(int chunkX, int chunkZ, long seed) {
        QualityRandom random = new QualityRandom(seed + (long)chunkZ * 8987899751L + (long)chunkX * 189878980451L);
        random.nextFloat();
        random.nextFloat();
        return random;
    }

    public int localToGlobal(int l) {
        return l + this.cityLevel;
    }

    public int globalToLocal(int l) {
        return l - this.cityLevel;
    }

    public boolean hasConnectionAt(int level, Orientation orientation) {
        return switch (orientation) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X -> this.hasConnectionAtX(level);
            case Orientation.Z -> this.hasConnectionAtZ(level);
        };
    }

    public boolean hasFrontPartFrom(BuildingInfo adj) {
        StreetType st = this.streetType;
        boolean elevated = this.isElevatedParkSection();
        if (elevated) {
            st = StreetType.PARK;
        }
        if (adj.hasBuilding && adj.frontType != null && st == StreetType.NORMAL && this.cityLevel < adj.cityLevel + adj.getNumFloors()) {
            RailChunkType type = this.getRailInfo().getType();
            if (type == RailChunkType.STATION_UNDERGROUND) {
                return false;
            }
            if (type == RailChunkType.GOING_DOWN_ONE_FROM_SURFACE) {
                return false;
            }
            if (this.getMaxHighwayLevel() >= 0) {
                return false;
            }
            int local = adj.globalToLocal(this.cityLevel);
            return !adj.isValidFloor(local) || !adj.getFloor(local).getMetaBoolean("dontconnect");
        }
        return false;
    }

    public boolean hasConnectionAtX(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.multiBuildingPos.isRightSide()) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtX.length) {
            return false;
        }
        if (level < this.floorTypes.length && this.floorTypes[level].getMetaBoolean("dontconnect")) {
            return false;
        }
        if (this.getXmin().hasFrontPartFrom(this)) {
            return true;
        }
        return this.connectionAtX[level];
    }

    public boolean hasConnectionAtXFromStreet(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.multiBuildingPos.isRightSide()) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtX.length) {
            return false;
        }
        if (this.hasFrontPartFrom(this.getXmin())) {
            return true;
        }
        return this.connectionAtX[level];
    }

    public boolean hasConnectionAtZ(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.multiBuildingPos.isBottomSide()) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtZ.length) {
            return false;
        }
        if (level < this.floorTypes.length && this.floorTypes[level].getMetaBoolean("dontconnect")) {
            return false;
        }
        if (this.getZmin().hasFrontPartFrom(this)) {
            return true;
        }
        return this.connectionAtZ[level];
    }

    public boolean hasConnectionAtZFromStreet(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.multiBuildingPos.isBottomSide()) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtZ.length) {
            return false;
        }
        if (this.hasFrontPartFrom(this.getZmin())) {
            return true;
        }
        return this.connectionAtZ[level];
    }

    public int getLowestCityHeightAtChunkCorner() {
        BuildingInfo info00 = this.getXmin().getZmin();
        BuildingInfo info01 = this.getXmin();
        BuildingInfo info10 = this.getZmin();
        if (this.isCity && info10.isCity && info00.isCity && info01.isCity) {
            return 100000;
        }
        if (!(this.isCity || info10.isCity || info00.isCity || info01.isCity)) {
            return 100000;
        }
        int h = this.getCityHeightForChunk();
        h = Math.min(h, info01.getCityHeightForChunk());
        h = Math.min(h, info10.getCityHeightForChunk());
        h = Math.min(h, info00.getCityHeightForChunk());
        return h;
    }

    public int getCityHeightForChunk() {
        if (this.isCity) {
            return this.getCityGroundLevel();
        }
        if (this.isOcean()) {
            return this.groundLevel - this.profile.OCEAN_CORRECTION_BORDER;
        }
        return 100000;
    }

    private MinMax getDesiredMaxHeightL1() {
        if (this.desiredMaxHeight1 == null) {
            int h = this.getLowestCityHeightAtChunkCorner();
            int cx = this.chunkX;
            int cz = this.chunkZ;
            if (h < 256) {
                this.desiredMaxHeight1 = new MinMax(h + LostCityTerrainFeature.getRandomizedOffset(cx, cz, this.profile.TERRAIN_FIX_LOWER_MIN_OFFSET, this.profile.TERRAIN_FIX_LOWER_MAX_OFFSET), h + LostCityTerrainFeature.getRandomizedOffset(cx, cz, this.profile.TERRAIN_FIX_UPPER_MIN_OFFSET, this.profile.TERRAIN_FIX_UPPER_MAX_OFFSET));
                return this.desiredMaxHeight1;
            }
            MinMax minMax = new MinMax();
            this.getXmin().getZmin().updateMinMaxL1(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL1(cx - 1, cz - 1));
            this.getXmin().updateMinMaxL1(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL1(cx - 1, cz));
            this.getXmin().getZmax().updateMinMaxL1(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL1(cx - 1, cz + 1));
            this.getZmin().updateMinMaxL1(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL1(cx, cz - 1));
            this.getZmax().updateMinMaxL1(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL1(cx, cz + 1));
            this.getXmax().getZmin().updateMinMaxL1(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL1(cx + 1, cz - 1));
            this.getXmax().updateMinMaxL1(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL1(cx + 1, cz));
            this.getXmax().getZmax().updateMinMaxL1(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL1(cx + 1, cz + 1));
            this.desiredMaxHeight1 = minMax;
        }
        return this.desiredMaxHeight1;
    }

    public MinMax getDesiredMaxHeightL2() {
        if (this.desiredTerrainCorrectionHeights == null) {
            MinMax mm = this.getDesiredMaxHeightL1();
            if (mm.min < 256) {
                this.desiredTerrainCorrectionHeights = new MinMax(mm);
                return this.desiredTerrainCorrectionHeights;
            }
            int cx = this.chunkX;
            int cz = this.chunkZ;
            MinMax minMax = new MinMax();
            this.getXmin().getZmin().updateMinMaxL2(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL2(cx - 1, cz - 1));
            this.getXmin().updateMinMaxL2(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL2(cx - 1, cz));
            this.getXmin().getZmax().updateMinMaxL2(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL2(cx - 1, cz + 1));
            this.getZmin().updateMinMaxL2(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL2(cx, cz - 1));
            this.getZmax().updateMinMaxL2(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL2(cx, cz + 1));
            this.getXmax().getZmin().updateMinMaxL2(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL2(cx + 1, cz - 1));
            this.getXmax().updateMinMaxL2(minMax, 20 + LostCityTerrainFeature.getHeightOffsetL2(cx + 1, cz));
            this.getXmax().getZmax().updateMinMaxL2(minMax, 25 + LostCityTerrainFeature.getHeightOffsetL2(cx + 1, cz + 1));
            this.desiredTerrainCorrectionHeights = minMax;
        }
        return this.desiredTerrainCorrectionHeights;
    }

    public void updateMinMaxL2(MinMax minMax, int offs) {
        MinMax h = this.getDesiredMaxHeightL1();
        if (h.min - offs < minMax.min) {
            minMax.min = h.min - offs;
        }
        if (h.max + offs < minMax.max) {
            minMax.max = h.max + offs;
        }
    }

    private void updateMinMaxL1(MinMax minMax, int offs) {
        int h = this.getLowestCityHeightAtChunkCorner();
        if (h - offs < minMax.min) {
            minMax.min = h - offs;
        }
        if (h + offs < minMax.max) {
            minMax.max = h + offs;
        }
    }

    @Override
    public boolean isCity() {
        return this.isCity;
    }

    @Override
    public String getBuildingType() {
        return this.hasBuilding ? this.buildingType.getName() : null;
    }

    @Override
    public int getCityLevel() {
        return this.cityLevel;
    }

    @Override
    public int getNumFloors() {
        return this.floors;
    }

    @Override
    public int getNumCellars() {
        return this.cellars;
    }

    @Override
    public float getDamage(int chunkY) {
        return this.getDamageArea().getDamage(this.chunkX * 16 + 8, chunkY * 16 + 8, this.chunkZ * 16 + 8);
    }

    @Override
    public Collection<ILostExplosion> getExplosions() {
        return new ArrayList<ILostExplosion>(this.getDamageArea().getExplosions());
    }

    @Override
    public int getMaxHighwayLevel() {
        return Math.max(this.getHighwayXLevel(), this.getHighwayZLevel());
    }

    @Override
    @Nonnull
    public RailChunkType getRailType() {
        return this.getRailInfo().getType();
    }

    @Override
    public int getRailLevel() {
        return this.getRailInfo().getLevel();
    }

    @Override
    @Nullable
    public ILostCityInfo getCityInfo() {
        if (City.isCityCenter(this.chunkX, this.chunkZ, this.provider)) {
            return new ILostCityInfo(){

                @Override
                public float getCityRadius() {
                    return City.getCityRadius(BuildingInfo.this.chunkX, BuildingInfo.this.chunkZ, BuildingInfo.this.provider);
                }

                @Override
                public String getCityStyle() {
                    return City.getCityStyleForCityCenter(BuildingInfo.this.chunkX, BuildingInfo.this.chunkZ, BuildingInfo.this.provider);
                }
            };
        }
        return null;
    }

    @Override
    public int getRuinLevel() {
        if ((double)this.profile.RUIN_CHANCE <= 0.0) {
            return -1;
        }
        if (this.ruinHeight < 0.0f) {
            return -1;
        }
        return (int)((float)(this.getCityGroundLevel() + 1) + this.ruinHeight * (float)this.getNumFloors() * 6.0f);
    }

    @Override
    @Nullable
    public ILostSphere getSphere() {
        CitySphere sphere = CitySphere.getCitySphere(this.chunkX, this.chunkZ, this.provider);
        if (sphere.isEnabled()) {
            return sphere;
        }
        return null;
    }

    @Nullable
    public static CitySphere getSphereInt(int x, int y, int z, IDimensionInfo provider) {
        double sqdist;
        CitySphere sphere = CitySphere.getCitySphere(x >> 4, z >> 4, provider);
        if (sphere.isEnabled() && (sqdist = sphere.getCenterPos().m_203198_((double)x, (double)y, (double)z)) <= (double)(sphere.getRadius() * sphere.getRadius())) {
            return sphere;
        }
        return null;
    }

    @Nullable
    public static CitySphere getSphereInt(int x, int z, IDimensionInfo provider) {
        double sqdist;
        CitySphere sphere = CitySphere.getCitySphere(x >> 4, z >> 4, provider);
        if (sphere.isEnabled() && (sqdist = sphere.getCenterPos().m_203198_((double)x, (double)sphere.getCenterPos().m_123342_(), (double)z)) <= (double)(sphere.getRadius() * sphere.getRadius())) {
            return sphere;
        }
        return null;
    }

    public static class MinMax {
        public int min;
        public int max;

        public MinMax(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public MinMax(MinMax mm) {
            this.min = mm.min;
            this.max = mm.max;
        }

        public MinMax() {
            this.max = 100000;
            this.min = 100000;
        }
    }

    public static enum StreetType {
        NORMAL,
        FULL,
        PARK;

    }

    public static class ConditionTodo {
        private final String condition;
        private final String part;
        private final String building;

        public ConditionTodo(String condition, String part, BuildingInfo info) {
            this.part = part == null ? "<none>" : part;
            this.condition = condition;
            this.building = info.hasBuilding ? info.getBuildingType() : "<none>";
        }

        public String getCondition() {
            return this.condition;
        }

        public String getPart() {
            return this.part;
        }

        public String getBuilding() {
            return this.building;
        }
    }
}

