/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.Tags;

public class LostCitySphereFeature
extends Feature<NoneFeatureConfiguration> {
    public static Holder<PlacedFeature> SPHERE_CONFIGURED_FEATURE;

    public static void registerConfiguredFeatures() {
        SPHERE_CONFIGURED_FEATURE = LostCitySphereFeature.registerPlacedFeature(new PlacementModifier[]{CountPlacement.m_191628_((int)1)});
    }

    public LostCitySphereFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> Holder<PlacedFeature> registerPlacedFeature(PlacementModifier ... placementModifiers) {
        Holder configuredFeatureHolder = Holder.m_205709_((Object)new ConfiguredFeature((Feature)((LostCitySphereFeature)((Object)Registration.LOSTCITY_SPHERE_FEATURE.get())), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        return PlacementUtils.m_206513_((String)"lostcities:spheres", (Holder)configuredFeatureHolder, (PlacementModifier[])placementModifiers);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        IDimensionInfo diminfo;
        WorldGenLevel level = context.m_159774_();
        if (level instanceof WorldGenRegion && (diminfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo(level)) != null) {
            WorldGenRegion region = (WorldGenRegion)level;
            ChunkPos center = region.m_143488_();
            Holder biome = region.m_204166_(center.m_151394_(60));
            if (biome.m_203656_(Tags.Biomes.IS_VOID)) {
                return false;
            }
            int chunkX = center.f_45578_;
            int chunkZ = center.f_45579_;
            diminfo.setWorld(level);
            diminfo.getFeature().generateSpheres(region, region.m_6325_(chunkX, chunkZ));
            return true;
        }
        return false;
    }
}

