/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.commons.lang3.tuple.Pair;

public class GlobalTodo
extends SavedData {
    public static final String NAME = "LostCityTodo";
    private Map<BlockPos, Consumer<ServerLevel>> todo = new HashMap<BlockPos, Consumer<ServerLevel>>();
    private Map<BlockPos, Pair<BlockState, ResourceLocation>> todoSpawners = new HashMap<BlockPos, Pair<BlockState, ResourceLocation>>();
    private Map<BlockPos, Pair<BlockState, CompoundTag>> todoBlockEntities = new HashMap<BlockPos, Pair<BlockState, CompoundTag>>();

    @Nonnull
    public static GlobalTodo getData(Level world) {
        if (world.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (GlobalTodo)storage.m_164861_(GlobalTodo::new, GlobalTodo::new, NAME);
    }

    public GlobalTodo() {
    }

    public GlobalTodo(CompoundTag nbt) {
        ListTag spawners = nbt.m_128437_("spawners", 10);
        for (Tag spawner : spawners) {
            CompoundTag spawnerTag = (CompoundTag)spawner;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)spawnerTag.m_128469_("pos"));
            BlockState state = NbtUtils.m_129241_((CompoundTag)spawnerTag.m_128469_("state"));
            ResourceLocation entity = new ResourceLocation(spawnerTag.m_128461_("entity"));
            this.addSpawnerTodo(pos, state, entity);
        }
        ListTag blockEntities = nbt.m_128437_("blockentities", 10);
        for (Tag blockEntity : blockEntities) {
            CompoundTag blockEntityTag = (CompoundTag)blockEntity;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)blockEntityTag.m_128469_("pos"));
            BlockState state = NbtUtils.m_129241_((CompoundTag)blockEntityTag.m_128469_("state"));
            CompoundTag tag = blockEntityTag.m_128469_("tag");
            this.addBlockEntityTodo(pos, state, tag);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag spawners = new ListTag();
        this.todoSpawners.forEach((pos, pair) -> {
            CompoundTag spawnerTag = new CompoundTag();
            spawnerTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            spawnerTag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)((BlockState)pair.getLeft())));
            spawnerTag.m_128359_("entity", ((ResourceLocation)pair.getRight()).toString());
            spawners.add((Object)spawnerTag);
        });
        tag.m_128365_("spawners", (Tag)spawners);
        ListTag blockEntities = new ListTag();
        this.todoBlockEntities.forEach((pos, pair) -> {
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            blockEntityTag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)((BlockState)pair.getLeft())));
            blockEntityTag.m_128365_("tag", (Tag)pair.getRight());
            blockEntities.add((Object)blockEntityTag);
        });
        tag.m_128365_("blockentities", (Tag)blockEntities);
        return tag;
    }

    public void addTodo(BlockPos pos, Consumer<ServerLevel> code) {
        this.todo.put(pos, code);
    }

    public void addSpawnerTodo(BlockPos pos, BlockState spawnerState, ResourceLocation randomEntity) {
        this.todoSpawners.put(pos, (Pair<BlockState, ResourceLocation>)Pair.of((Object)spawnerState, (Object)randomEntity));
    }

    public void addBlockEntityTodo(BlockPos pos, BlockState state, CompoundTag tag) {
        this.todoBlockEntities.put(pos, (Pair<BlockState, CompoundTag>)Pair.of((Object)state, (Object)tag));
    }

    public void executeAndClearTodo(ServerLevel level) {
        Map<BlockPos, Consumer<ServerLevel>> copy = this.todo;
        this.todo = new HashMap<BlockPos, Consumer<ServerLevel>>();
        copy.forEach((pos, code) -> code.accept(level));
        Map<BlockPos, Pair<BlockState, ResourceLocation>> copySpawners = this.todoSpawners;
        this.todoSpawners = new HashMap<BlockPos, Pair<BlockState, ResourceLocation>>();
        copySpawners.forEach((pos, pair) -> {
            BlockState spawnerState = (BlockState)pair.getLeft();
            ResourceLocation randomEntity = (ResourceLocation)pair.getRight();
            if (level.m_8055_(pos).m_60734_() == spawnerState.m_60734_()) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                level.m_7731_(pos, spawnerState, 2);
                LostCityTerrainFeature.createSpawner((Level)level, pos, randomEntity);
            }
        });
        Map<BlockPos, Pair<BlockState, CompoundTag>> copyBlockEntities = this.todoBlockEntities;
        this.todoBlockEntities = new HashMap<BlockPos, Pair<BlockState, CompoundTag>>();
        copyBlockEntities.forEach((pos, pair) -> {
            BlockState state = (BlockState)pair.getLeft();
            CompoundTag tag = (CompoundTag)pair.getRight();
            BlockEntity be = level.m_7702_(pos);
            if (be != null) {
                be.m_142466_(tag);
            }
        });
    }
}

