/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATEGORY_PROFILES = "profiles";
    public static final String CATEGORY_GENERAL = "general";
    public static final String[] BLOCKS_REQUIRING_LIGHTING_UPDATES = new String[]{"minecraft:glowstone", "minecraft:redstone_torch", "minecraft:lit_pumpkin", "minecraft:magma"};
    public static final boolean DEBUG = false;
    public static ForgeConfigSpec.ConfigValue<String> SPECIAL_BED_BLOCK;
    private static final String[] DEFAULT_DIMENSION_PROFILES;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_PROFILES;
    private static Map<ResourceKey<Level>, String> dimensionProfileCache;
    public static String profileFromClient;
    public static String jsonFromClient;
    public static final ForgeConfigSpec.ConfigValue<String> SELECTED_PROFILE;
    public static final ForgeConfigSpec.ConfigValue<String> SELECTED_CUSTOM_JSON;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    private static final ForgeConfigSpec.Builder SERVER_BUILDER;
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec SERVER_CONFIG;

    public static void reset() {
        profileFromClient = null;
        jsonFromClient = null;
        dimensionProfileCache = null;
    }

    public static void resetProfileCache() {
        dimensionProfileCache = null;
    }

    public static void registerLostCityDimension(ResourceKey<Level> type, String profile) {
        String profileForDimension = Config.getProfileForDimension(type);
        if (profileForDimension == null) {
            dimensionProfileCache.put(type, profile);
        }
    }

    public static String getProfileForDimension(ResourceKey<Level> type) {
        if (dimensionProfileCache == null) {
            String profile;
            dimensionProfileCache = new HashMap<ResourceKey<Level>, String>();
            for (String dp : (List)DIMENSION_PROFILES.get()) {
                String[] split = dp.split("=");
                if (split.length != 2) {
                    LostCities.getLogger().error("Bad format for config value: '{}'!", (Object)dp);
                    continue;
                }
                ResourceKey dimensionType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(split[0]));
                String profileName = split[1];
                LostCityProfile profile2 = ProfileSetup.STANDARD_PROFILES.get(profileName);
                if (profile2 != null) {
                    dimensionProfileCache.put((ResourceKey<Level>)dimensionType, profileName);
                    continue;
                }
                LostCities.getLogger().error("Cannot find profile: {} for dimension {}!", (Object)profileName, (Object)split[0]);
            }
            String selectedProfile = (String)SELECTED_PROFILE.get();
            if ("<CHECK>".equals(selectedProfile)) {
                if (profileFromClient != null && !profileFromClient.isEmpty()) {
                    SELECTED_PROFILE.set((Object)profileFromClient);
                    if (jsonFromClient != null && !jsonFromClient.isEmpty()) {
                        SELECTED_CUSTOM_JSON.set((Object)jsonFromClient);
                    } else {
                        SELECTED_CUSTOM_JSON.set((Object)"");
                    }
                    selectedProfile = profileFromClient;
                } else {
                    SELECTED_PROFILE.set((Object)"");
                    selectedProfile = "";
                }
            }
            if (!selectedProfile.isEmpty()) {
                dimensionProfileCache.put((ResourceKey<Level>)Level.f_46428_, selectedProfile);
                String json = (String)SELECTED_CUSTOM_JSON.get();
                if (json != null && !json.isEmpty()) {
                    LostCityProfile profile3 = new LostCityProfile("customized", json);
                    if (!ProfileSetup.STANDARD_PROFILES.containsKey("customized")) {
                        ProfileSetup.STANDARD_PROFILES.put("customized", new LostCityProfile("customized", false));
                    }
                    ProfileSetup.STANDARD_PROFILES.get("customized").copyFrom(profile3);
                }
            }
            if ((profile = Config.getProfileForDimension((ResourceKey<Level>)Level.f_46428_)) != null && !profile.isEmpty() && ProfileSetup.STANDARD_PROFILES.get((Object)profile).GENERATE_NETHER) {
                dimensionProfileCache.put((ResourceKey<Level>)Level.f_46429_, "cavern");
            }
        }
        return dimensionProfileCache.get(type);
    }

    static {
        DEFAULT_DIMENSION_PROFILES = new String[]{"lostcities:lostcity=default"};
        dimensionProfileCache = null;
        profileFromClient = null;
        jsonFromClient = null;
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        CLIENT_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        SERVER_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        DIMENSION_PROFILES = COMMON_BUILDER.comment("A list of dimensions with associated city generation profiles (format <dimensionid>=<profilename>").defineList("dimensionsWithProfiles", (List)Lists.newArrayList((Object[])DEFAULT_DIMENSION_PROFILES), s -> s instanceof String);
        SPECIAL_BED_BLOCK = SERVER_BUILDER.comment("Block to put underneath a bed so that it qualifies as a teleporter bed").define("specialBedBlock", (Object)"minecraft:diamond_block");
        SELECTED_PROFILE = SERVER_BUILDER.define("selectedProfile", (Object)"<CHECK>");
        SELECTED_CUSTOM_JSON = SERVER_BUILDER.define("selectedCustomJson", (Object)"");
        SERVER_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

