/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.WorldTools;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class EditModeData
extends SavedData {
    public static final String NAME = "LostCityEditData";
    private final Map<ChunkCoord, List<PartData>> partData = new HashMap<ChunkCoord, List<PartData>>();

    @Nonnull
    public static EditModeData getData() {
        ServerLevel overworld = WorldTools.getOverworld();
        DimensionDataStorage storage = overworld.m_8895_();
        return (EditModeData)storage.m_164861_(EditModeData::new, EditModeData::new, NAME);
    }

    public EditModeData() {
    }

    public EditModeData(CompoundTag nbt) {
        ListTag data = nbt.m_128437_("data", 10);
        for (Tag t : data) {
            CompoundTag pdTag = (CompoundTag)t;
            ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(pdTag.m_128461_("level")));
            int chunkX = pdTag.m_128451_("x");
            int chunkZ = pdTag.m_128451_("z");
            ChunkCoord pos = new ChunkCoord((ResourceKey<Level>)level, chunkX, chunkZ);
            String part = pdTag.m_128461_("part");
            int y = pdTag.m_128451_("y");
            this.addPartData(pos, y, part);
        }
    }

    public void addPartData(ChunkCoord pos, int y, String partName) {
        this.partData.computeIfAbsent(pos, p -> new ArrayList()).add(new PartData(partName, y));
    }

    public List<PartData> getPartData(ChunkCoord pos) {
        return this.partData.getOrDefault(pos, Collections.emptyList());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag data = new ListTag();
        this.partData.forEach((pos, list) -> {
            for (PartData pd : list) {
                CompoundTag pdTag = new CompoundTag();
                pdTag.m_128359_("level", pos.dimension().m_135782_().toString());
                pdTag.m_128405_("x", pos.chunkX());
                pdTag.m_128405_("z", pos.chunkX());
                pdTag.m_128359_("part", pd.partName());
                pdTag.m_128405_("y", pd.y());
                data.add((Object)pdTag);
            }
        });
        tag.m_128365_("data", (Tag)data);
        return tag;
    }

    public record PartData(String partName, int y) {
    }
}

