/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import mcjty.lostcities.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class CommandSaveProfile
implements Command<CommandSourceStack> {
    private static final CommandSaveProfile CMD = new CommandSaveProfile();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"saveprofile").requires(cs -> cs.m_6761_(0))).then(Commands.m_82129_((String)"profile", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = (String)context.getArgument("profile", String.class);
        LostCityProfile profile = ProfileSetup.STANDARD_PROFILES.get(name);
        if (profile == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal(ChatFormatting.RED + "Could not find profile '" + name + "'!"), true);
            return 0;
        }
        JsonObject jsonObject = profile.toJson(false);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (PrintWriter writer = new PrintWriter(new File(name + ".json"));){
            writer.print(gson.toJson((JsonElement)jsonObject));
            writer.flush();
        }
        catch (FileNotFoundException e) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal(ChatFormatting.RED + "Error saving profile '" + name + "'!"), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal(ChatFormatting.GREEN + "Saved profile '" + name + "'!"), true);
        return 0;
    }
}

