/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.editor.Editor;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;

public class CommandCreatePart
implements Command<CommandSourceStack> {
    private static final CommandCreatePart CMD = new CommandCreatePart();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"createpart").requires(cs -> cs.m_6761_(1))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = (String)context.getArgument("name", String.class);
        BuildingPart part = AssetRegistries.PARTS.get((CommonLevelAccessor)((CommandSourceStack)context.getSource()).m_81372_(), name);
        if (part == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Error finding part '" + name + "'!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        BlockPos start = player.m_142538_();
        ServerLevel level = player.m_183503_();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        Editor.startEditing(part, player, start, level, dimInfo);
        return 0;
    }
}

