/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.QuarryPlus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class QuarryChunkLoadUtil {
    private static final Logger LOGGER = QuarryPlus.getLogger(QuarryChunkLoadUtil.class);

    public static boolean isChunkLoaded(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            long key = new ChunkPos(pos).m_45588_();
            return serverWorld.m_8902_().contains(key);
        }
        return false;
    }

    public static boolean makeChunkLoaded(Level world, BlockPos pos, boolean machineEnabled) {
        if (!machineEnabled) {
            return false;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            LOGGER.debug("Asked to force loading chunk at {}", (Object)pos);
            if (QuarryChunkLoadUtil.isChunkLoaded(world, pos)) {
                return true;
            }
            serverWorld.m_8602_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), true);
            return false;
        }
        return false;
    }

    public static void makeChunkUnloaded(Level world, BlockPos pos, boolean preLoaded) {
        LOGGER.debug("Asked to unload chunk. preLoaded={}", (Object)preLoaded);
        if (!preLoaded && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8602_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), false);
        }
    }
}

