/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.machines.advquarry.AdvActionMessage;
import com.yogpc.qp.machines.controller.ControllerOpenMessage;
import com.yogpc.qp.machines.controller.SetSpawnerEntityMessage;
import com.yogpc.qp.machines.filler.FillerButtonMessage;
import com.yogpc.qp.machines.marker.FlexMarkerMessage;
import com.yogpc.qp.machines.marker.Marker16Message;
import com.yogpc.qp.machines.mini_quarry.MiniListSyncMessage;
import com.yogpc.qp.machines.mini_quarry.MiniRequestListMessage;
import com.yogpc.qp.machines.mover.MoverMessage;
import com.yogpc.qp.machines.placer.RemotePlacerMessage;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.LevelMessage;
import com.yogpc.qp.packet.TileMessage;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("quarryplus", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final Proxy PROXY = ProxyProvider.getInstance();

    public static void init() {
        AtomicInteger id = new AtomicInteger(1);
        INSTANCE.registerMessage(id.getAndIncrement(), TileMessage.class, TileMessage::write, TileMessage::new, PacketHandler.setHandled(TileMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), ClientSyncMessage.class, ClientSyncMessage::write, ClientSyncMessage::new, PacketHandler.setHandled(ClientSyncMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), Marker16Message.class, Marker16Message::write, Marker16Message::new, PacketHandler.setHandled(Marker16Message::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), FlexMarkerMessage.class, FlexMarkerMessage::write, FlexMarkerMessage::new, PacketHandler.setHandled(FlexMarkerMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), LevelMessage.class, LevelMessage::write, LevelMessage::new, PacketHandler.setHandled(LevelMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), MoverMessage.class, MoverMessage::write, MoverMessage::new, PacketHandler.setHandled(MoverMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), AdvActionMessage.class, AdvActionMessage::write, AdvActionMessage::new, PacketHandler.setHandled(AdvActionMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), SetSpawnerEntityMessage.class, SetSpawnerEntityMessage::write, SetSpawnerEntityMessage::new, PacketHandler.setHandled(SetSpawnerEntityMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), ControllerOpenMessage.class, ControllerOpenMessage::write, ControllerOpenMessage::new, PacketHandler.setHandled(ControllerOpenMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), MiniListSyncMessage.class, MiniListSyncMessage::write, MiniListSyncMessage::new, PacketHandler.setHandled(MiniListSyncMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), MiniRequestListMessage.class, MiniRequestListMessage::write, MiniRequestListMessage::new, PacketHandler.setHandled(MiniRequestListMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), FillerButtonMessage.class, FillerButtonMessage::write, FillerButtonMessage::new, PacketHandler.setHandled(FillerButtonMessage::onReceive));
        INSTANCE.registerMessage(id.getAndIncrement(), RemotePlacerMessage.class, RemotePlacerMessage::write, RemotePlacerMessage::new, PacketHandler.setHandled(RemotePlacerMessage::onReceive));
    }

    public static void sendToClient(@NotNull IMessage message, @NotNull Level world) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((Level)world).m_46472_()), (Object)message);
    }

    public static void sendToClientPlayer(@NotNull IMessage message, @NotNull ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public static void sendToServer(@NotNull IMessage message) {
        INSTANCE.sendToServer((Object)message);
    }

    @NotNull
    public static ResourceKey<Level> getDimension(@Nullable BlockEntity entity) {
        return Optional.ofNullable(entity).map(BlockEntity::m_58904_).map(Level::m_46472_).orElse(Level.f_46428_);
    }

    @NotNull
    public static Optional<Level> getWorld(@NotNull NetworkEvent.Context context, @NotNull BlockPos pos, @NotNull ResourceKey<Level> expectedDim) {
        return PROXY.getPacketWorld(context).filter(l -> l.m_46472_().equals((Object)expectedDim)).filter(l -> l.m_46749_(pos));
    }

    @NotNull
    public static Optional<Player> getPlayer(@NotNull NetworkEvent.Context context) {
        return PROXY.getPacketPlayer(context);
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> setHandled(BiConsumer<T, Supplier<NetworkEvent.Context>> execution) {
        return (t, supplier) -> {
            execution.accept((Object)t, (Supplier<NetworkEvent.Context>)supplier);
            ((NetworkEvent.Context)supplier.get()).setPacketHandled(true);
        };
    }

    private static abstract class Proxy {
        private Proxy() {
        }

        @NotNull
        abstract Optional<Level> getPacketWorld(@NotNull NetworkEvent.Context var1);

        @NotNull
        abstract Optional<Player> getPacketPlayer(@NotNull NetworkEvent.Context var1);
    }

    private static class ProxyProvider {
        private ProxyProvider() {
        }

        @NotNull
        private static Proxy getInstance() {
            return switch (FMLLoader.getDist()) {
                default -> throw new IncompatibleClassChangeError();
                case Dist.CLIENT -> new ClientSupplier().get();
                case Dist.DEDICATED_SERVER -> new ServerSupplier().get();
            };
        }

        private static class ClientSupplier {
            private ClientSupplier() {
            }

            @OnlyIn(value=Dist.CLIENT)
            Proxy get() {
                return new ProxyClient();
            }
        }

        private static class ServerSupplier {
            private ServerSupplier() {
            }

            Proxy get() {
                return new ProxyServer();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ProxyClient
    extends Proxy {
        private ProxyClient() {
        }

        @Override
        Optional<Level> getPacketWorld(NetworkEvent.Context context) {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return Optional.ofNullable(Minecraft.m_91087_().f_91073_);
            }
            return Optional.of(sender).map(ServerPlayer::m_183503_);
        }

        @Override
        Optional<Player> getPacketPlayer(NetworkEvent.Context context) {
            return Optional.ofNullable(context.getSender()).or(() -> Optional.ofNullable(Minecraft.m_91087_().f_91074_));
        }
    }

    private static class ProxyServer
    extends Proxy {
        private ProxyServer() {
        }

        @Override
        Optional<Level> getPacketWorld(NetworkEvent.Context context) {
            return Optional.ofNullable(context.getSender()).map(ServerPlayer::m_183503_);
        }

        @Override
        Optional<Player> getPacketPlayer(NetworkEvent.Context context) {
            return Optional.ofNullable(context.getSender());
        }
    }
}

