/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ftbchunks.FTBChunksProtectionCheck;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.quarry.QuarryBlock;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.SFQuarryEntity;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public final class SFQuarryBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "solid_fuel_quarry";

    public SFQuarryBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING, BlockStateProperties.f_61372_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43723_() == null ? Direction.NORTH : ctx.m_43723_().m_6350_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_) {
            Direction facing = entity == null ? Direction.NORTH : entity.m_6350_().m_122424_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SFQuarryEntity) {
                SFQuarryEntity quarry = (SFQuarryEntity)blockEntity;
                quarry.setTileDataFromItem(null);
                Area area = QuarryBlock.findArea(level, pos, facing.m_122424_(), quarry.storage::addItem);
                if (FTBChunksProtectionCheck.isAreaProtected(area, (ResourceKey<Level>)level.m_46472_())) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)new TranslatableComponent("quarryplus.chat.warn_protected_area"), false);
                    }
                } else if (area.maxX() - area.minX() > 1 && area.maxZ() - area.minZ() > 1) {
                    quarry.setState(QuarryState.WAITING, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing));
                    quarry.setArea(area);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    player.m_5661_((Component)new TranslatableComponent("quarryplus.chat.warn_area"), false);
                }
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, quarry.enabled);
                quarry.setChunkPreLoaded(preForced);
                PacketHandler.sendToClient(new TileMessage(quarry), level);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.f_46443_) {
                player.m_5661_((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof SFQuarryEntity) {
                SFQuarryEntity quarry = (SFQuarryEntity)blockEntity;
                ItemStack stack = player.m_21120_(hand);
                if (WrenchItems.isWrenchItem(stack)) {
                    quarry.setState(QuarryState.WAITING, state);
                    quarry.target = null;
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)quarry, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.SOLID_FUEL_QUARRY_TYPE.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : SFQuarryBlock.checkType(blockEntityType, Holder.SOLID_FUEL_QUARRY_TYPE, new CombinedBlockEntityTicker(SFQuarryEntity::tickFuel, TileQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }
}

