/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.quarry.Target;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PosesTarget
extends Target {
    private final List<BlockPos> posList;
    private final Iterator<BlockPos> iterator;
    @Nullable
    private BlockPos currentTarget;

    PosesTarget(List<BlockPos> posList) {
        this.posList = posList;
        this.iterator = posList.iterator();
        if (this.iterator.hasNext()) {
            this.currentTarget = this.iterator.next();
        }
    }

    static PosesTarget from(CompoundTag tag) {
        List<BlockPos> poses = Arrays.stream(tag.m_128467_("poses")).mapToObj(BlockPos::m_122022_).toList();
        return new PosesTarget(poses);
    }

    @Override
    @Nullable
    public BlockPos get(boolean goNext) {
        BlockPos pre = this.currentTarget;
        if (goNext) {
            this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
        }
        return pre;
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        return this.posList.stream();
    }

    @Override
    @NotNull
    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        LongArrayTag list = new LongArrayTag(this.allPoses().mapToLong(BlockPos::m_121878_).toArray());
        tag.m_128365_("poses", (Tag)list);
        return tag;
    }

    public String toString() {
        return "PosesTarget{currentTarget=" + this.currentTarget + ", size=" + this.posList.size() + "}";
    }
}

