/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.mini_quarry.BlockStatePredicate;
import com.yogpc.qp.machines.misc.IndexedButton;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MiniQuarryAddEntryGui
extends Screen
implements Button.OnPress {
    private final Consumer<BlockStatePredicate> callback;
    private EntryList list;
    private EditBox textField;

    protected MiniQuarryAddEntryGui(Screen parent, Consumer<BlockStatePredicate> callback) {
        super(parent.m_96636_());
        this.callback = callback;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        int width = this.f_96543_;
        int height = this.f_96544_;
        this.textField = new EditBox(this.f_96547_, width / 2 - 125, height - 56, 250, 20, (Component)new TextComponent(""));
        this.textField.m_94199_(512);
        this.list = new EntryList(this.getMinecraft(), width, height, 30, height - 70, 18, this, this::getEntries);
        IndexedButton button = new IndexedButton(1, width / 2 - buttonWidth / 2, height - 35, buttonWidth, 20, (Component)new TranslatableComponent("tof.add_new_ore"), this);
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)this.textField);
        this.m_142416_((GuiEventListener)button);
        this.m_94718_((GuiEventListener)this.list);
        this.textField.m_94190_(true);
        this.textField.m_94151_(s -> {
            this.list.m_6987_(null);
            this.list.updateList();
            this.list.m_93410_(this.list.m_93517_());
        });
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.list.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        MiniQuarryAddEntryGui.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)new TranslatableComponent("quarryplus.gui.new_entry"), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
    }

    private List<Pair<Kind, List<String>>> getEntries() {
        String filterText;
        String string = filterText = this.textField == null ? "" : this.textField.m_94155_();
        if (filterText.startsWith("#")) {
            String f = filterText.substring(1);
            return List.of(Pair.of((Object)((Object)Kind.TAG), Registry.f_122824_.m_203613_().map(TagKey::f_203868_).map(ResourceLocation::toString).filter(r -> r.contains(f)).sorted().collect(Collectors.toList())));
        }
        return List.of(Pair.of((Object)((Object)Kind.ALL), Stream.of("ALL").filter(r -> r.contains(filterText)).toList()), Pair.of((Object)((Object)Kind.BLOCK), ForgeRegistries.BLOCKS.getKeys().stream().map(ResourceLocation::toString).filter(r -> r.contains(filterText)).sorted().collect(Collectors.toList())));
    }

    public void m_93750_(Button button) {
        IndexedButton indexedButton;
        if (button instanceof IndexedButton && (indexedButton = (IndexedButton)button).id() == 1) {
            LocationEntry entry = (LocationEntry)this.list.m_93511_();
            if (entry != null) {
                String location = entry.getData();
                switch (entry.getKind()) {
                    case BLOCK: {
                        this.callback.accept(BlockStatePredicate.name(new ResourceLocation(location)));
                        break;
                    }
                    case TAG: {
                        this.callback.accept(BlockStatePredicate.tag(new ResourceLocation(location)));
                        break;
                    }
                    case ALL: {
                        this.callback.accept(BlockStatePredicate.all());
                        break;
                    }
                    default: {
                        QuarryPlus.LOGGER.warn("Not registered kind {} for {}.", (Object)entry.getKind(), (Object)location);
                        break;
                    }
                }
            } else {
                String maybePredicate = this.textField.m_94155_();
                if (!maybePredicate.isEmpty()) {
                    try {
                        new BlockStateParser(new StringReader(maybePredicate), true).m_116806_(true);
                        this.callback.accept(BlockStatePredicate.predicateString(maybePredicate));
                    }
                    catch (CommandSyntaxException e) {
                        QuarryPlus.LOGGER.debug("Invalid predicate {} was parsed but not added. Got {}.", (Object)maybePredicate, (Object)e);
                    }
                }
            }
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.textField.m_93696_() && this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    static class EntryList
    extends ObjectSelectionList<LocationEntry> {
        private final Screen parent;
        private final Supplier<List<Pair<Kind, List<String>>>> entriesSupplier;

        public EntryList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, Screen parent, Supplier<List<Pair<Kind, List<String>>>> entriesSupplier) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.parent = parent;
            this.entriesSupplier = entriesSupplier;
            this.updateList();
        }

        public void updateList() {
            this.m_93516_();
            List<Pair<Kind, List<String>>> kindListPairs = this.entriesSupplier.get();
            kindListPairs.forEach(kindListPair -> ((List)kindListPair.getValue()).stream().map(e -> new LocationEntry((String)e, this.parent, arg_0 -> ((EntryList)this).m_6987_(arg_0), (Kind)((Object)((Object)((Object)kindListPair.getKey()))))).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0)));
        }
    }

    private static enum Kind {
        BLOCK,
        TAG,
        ALL;

    }

    static class LocationEntry
    extends ObjectSelectionList.Entry<LocationEntry> {
        private final String data;
        private final Screen parent;
        private final Consumer<LocationEntry> setSelected;
        private final Kind kind;

        LocationEntry(String data, Screen parent, Consumer<LocationEntry> setSelected, Kind kind) {
            this.data = data;
            this.parent = parent;
            this.setSelected = setSelected;
            this.kind = kind;
        }

        public String getData() {
            return this.data;
        }

        public Kind getKind() {
            return this.kind;
        }

        public void m_6311_(PoseStack m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
            String name = (this.kind == Kind.TAG ? "#" : "") + this.data;
            Minecraft.m_91087_().f_91062_.m_92883_(m, name, (float)((this.parent.f_96543_ - Minecraft.m_91087_().f_91062_.m_92895_(name)) / 2), (float)(top + 2), 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.setSelected.accept(this);
            return false;
        }

        public Component m_142172_() {
            return new TranslatableComponent("narrator.select", new Object[]{this.data});
        }
    }
}

