/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.PickIterator;
import com.yogpc.qp.machines.TargetIterator;
import com.yogpc.qp.machines.filler.CircleGenerator;
import com.yogpc.qp.machines.filler.FillerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

public abstract class FillerTargetPosIterator
extends PickIterator<BlockPos> {
    final Area area;
    final int maxY;
    final int minY;

    protected FillerTargetPosIterator(Area area) {
        this.area = area;
        this.maxY = area.maxY();
        this.minY = area.minY();
    }

    @Override
    public boolean hasNext() {
        return this.area.minX() <= ((BlockPos)this.current).m_123341_() && ((BlockPos)this.current).m_123341_() <= this.area.maxX() && this.area.minZ() <= ((BlockPos)this.current).m_123343_() && ((BlockPos)this.current).m_123343_() <= this.area.maxZ() && this.minY <= ((BlockPos)this.current).m_123342_() && ((BlockPos)this.current).m_123342_() <= this.maxY;
    }

    abstract FillerEntity.Action type();

    public static FillerTargetPosIterator box(Area area) {
        return new Box(area);
    }

    static final class Box
    extends FillerTargetPosIterator {
        TargetIterator iterator;

        Box(Area area) {
            super(area);
            this.setNewIterator();
            this.reset();
        }

        @Override
        FillerEntity.Action type() {
            return FillerEntity.Action.BOX;
        }

        @Override
        public void reset() {
            this.iterator.reset();
            this.iterator.next();
            super.reset();
        }

        @Override
        protected BlockPos update() {
            if (this.iterator.hasNext()) {
                TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
                return new BlockPos(xz.x(), ((BlockPos)this.current).m_123342_(), xz.z());
            }
            this.setNewIterator();
            TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
            return new BlockPos(xz.x(), ((BlockPos)this.current).m_123342_() + 1, xz.z());
        }

        @Override
        public void setCurrent(BlockPos current) {
            super.setCurrent(current);
            this.iterator.setCurrent(new TargetIterator.XZPair(current.m_123341_(), current.m_123343_()));
            this.iterator.next();
        }

        @Override
        public BlockPos head() {
            TargetIterator.XZPair head = (TargetIterator.XZPair)this.iterator.head();
            return new BlockPos(head.x(), this.minY, head.z());
        }

        private void setNewIterator() {
            Area fixedArea = new Area(this.area.minX() - 1, this.area.minY(), this.area.minZ() - 1, this.area.maxX() + 1, this.area.maxY(), this.area.maxZ() + 1, this.area.direction());
            this.iterator = TargetIterator.of(fixedArea);
        }
    }

    static final class Pillar
    extends FillerTargetPosIterator {
        private Iterator<TargetIterator.XZPair> iterator;

        Pillar(Area area) {
            super(area);
            this.setNewIterator();
            this.reset();
        }

        @Override
        protected BlockPos update() {
            if (this.iterator.hasNext()) {
                TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
                return new BlockPos(xz.x(), ((BlockPos)this.current).m_123342_(), xz.z());
            }
            this.setNewIterator();
            TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
            return new BlockPos(xz.x(), ((BlockPos)this.current).m_123342_() + 1, xz.z());
        }

        private Seq<TargetIterator.XZPair> getCircle() {
            return CircleGenerator.makeCircle(new TargetIterator.XZPair((this.area.minX() + this.area.maxX() + 1) / 2, (this.area.minZ() + this.area.maxZ() + 1) / 2), Math.min(this.area.maxX() - this.area.minX() + 1, this.area.maxZ() - this.area.minZ() + 1));
        }

        @Override
        public BlockPos head() {
            TargetIterator.XZPair firstXZ = (TargetIterator.XZPair)this.getCircle().head();
            return new BlockPos(firstXZ.x(), this.minY, firstXZ.z());
        }

        @Override
        public void reset() {
            this.iterator.next();
            super.reset();
        }

        @Override
        public void setCurrent(BlockPos current) {
            super.setCurrent(current);
            TargetIterator.XZPair t = new TargetIterator.XZPair(current.m_123341_(), current.m_123343_());
            this.iterator = this.iterator.dropWhile(p -> !p.equals(t)).drop(1);
        }

        private void setNewIterator() {
            this.iterator = this.getCircle().iterator();
        }

        @Override
        FillerEntity.Action type() {
            return FillerEntity.Action.PILLAR;
        }
    }

    static final class Wall
    extends FillerTargetPosIterator {
        Wall(Area area) {
            super(area);
            this.reset();
        }

        @Override
        FillerEntity.Action type() {
            return FillerEntity.Action.WALL;
        }

        @Override
        protected BlockPos update() {
            BlockPos next;
            if (((BlockPos)this.current).m_123342_() == this.minY || ((BlockPos)this.current).m_123342_() == this.maxY) {
                next = ((BlockPos)this.current).m_123341_() < this.area.maxX() ? ((BlockPos)this.current).m_142629_(Direction.Axis.X, 1) : (((BlockPos)this.current).m_123343_() < this.area.maxZ() ? new BlockPos(this.area.minX(), ((BlockPos)this.current).m_123342_(), ((BlockPos)this.current).m_123343_() + 1) : new BlockPos(this.area.minX(), ((BlockPos)this.current).m_123342_() + 1, this.area.minZ()));
            } else if (((BlockPos)this.current).m_123341_() == this.area.minX()) {
                next = ((BlockPos)this.current).m_123343_() == this.area.maxZ() ? ((BlockPos)this.current).m_142629_(Direction.Axis.X, 1) : ((BlockPos)this.current).m_142629_(Direction.Axis.Z, 1);
            } else if (((BlockPos)this.current).m_123343_() == this.area.maxZ()) {
                next = ((BlockPos)this.current).m_123341_() == this.area.maxX() ? ((BlockPos)this.current).m_142629_(Direction.Axis.Z, -1) : ((BlockPos)this.current).m_142629_(Direction.Axis.X, 1);
            } else if (((BlockPos)this.current).m_123341_() == this.area.maxX()) {
                next = ((BlockPos)this.current).m_123343_() == this.area.minZ() ? ((BlockPos)this.current).m_142629_(Direction.Axis.X, -1) : ((BlockPos)this.current).m_142629_(Direction.Axis.Z, -1);
            } else if (((BlockPos)this.current).m_123343_() == this.area.minZ()) {
                next = ((BlockPos)this.current).m_123341_() == this.area.minX() + 1 ? new BlockPos(this.area.minX(), ((BlockPos)this.current).m_123342_() + 1, this.area.minZ()) : ((BlockPos)this.current).m_142629_(Direction.Axis.X, -1);
            } else {
                throw new IllegalStateException("Bad Position(%s) in %s".formatted(this.current, this.area));
            }
            this.current = next;
            return next;
        }

        @Override
        public BlockPos head() {
            return new BlockPos(this.area.minX(), this.minY, this.area.minZ());
        }
    }
}

