/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.advpump.BlockAdvPump;
import com.yogpc.qp.machines.advpump.EnchantmentEfficiency;
import com.yogpc.qp.machines.advpump.Target;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class TileAdvPump
extends PowerTile
implements MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
CheckerLog,
ClientSync,
ModuleInventory.HasModuleInventory {
    private final MachineStorage storage = new MachineStorage();
    private int y;
    private Target target;
    private EnchantmentEfficiency enchantmentEfficiency;
    private boolean finished = false;
    public boolean deleteFluid = false;
    public boolean placeFrame = true;
    private final ModuleInventory moduleInventory;
    private Set<QuarryModule> modules = Set.of();
    private boolean isBlockModuleLoaded = false;
    private final AdvPumpCache cache = new AdvPumpCache();

    public TileAdvPump(BlockPos pos, BlockState state) {
        super(Holder.ADV_PUMP_TYPE, pos, state);
        this.y = pos.m_123342_() - 1;
        this.setEnchantment(new EnchantmentEfficiency(List.of()));
        this.moduleInventory = new ModuleInventory(5, this::updateModule, TileAdvPump::isCapableModule, (ModuleInventory.HasModuleInventory)this);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.m_128365_("storage", (Tag)this.storage.toNbt());
        nbt.m_128405_("y", this.y);
        nbt.m_128365_("enchantments", (Tag)this.enchantmentEfficiency.toNbt());
        nbt.m_128379_("finished", this.finished);
        nbt.m_128379_("deleteFluid", this.deleteFluid);
        nbt.m_128379_("placeFrame", this.placeFrame);
        nbt.m_128365_("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.storage.readNbt(nbt.m_128469_("storage"));
        this.y = nbt.m_128451_("y");
        this.setEnchantment(EnchantmentEfficiency.fromNbt(nbt.m_128469_("enchantments")));
        this.finished = nbt.m_128471_("finished");
        this.deleteFluid = nbt.m_128471_("deleteFluid");
        this.placeFrame = nbt.m_128471_("placeFrame");
        this.moduleInventory.deserializeNBT(nbt.m_128469_("moduleInventory"));
        this.isBlockModuleLoaded = false;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileAdvPump pump) {
        if (!pump.isBlockModuleLoaded) {
            pump.updateModule();
            pump.isBlockModuleLoaded = true;
        }
        long fluidSum = pump.storage.getFluidMap().values().stream().mapToLong(Long::longValue).sum();
        if (pump.hasEnoughEnergy() && !pump.finished && fluidSum <= (long)pump.enchantmentEfficiency.fluidCapacity) {
            if (pump.target == null) {
                BlockPos initPos = pos.m_175288_(pump.y);
                pump.target = Target.getTarget(world, initPos, pump.enchantmentEfficiency.rangePredicate(initPos), pump::isReplaceBlock, pump.enchantmentEfficiency.areaSize());
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (pump.target.hasNext()) {
                while (pump.target.hasNext()) {
                    BlockPos target = pump.target.next();
                    BreakResult result = pump.pumpFluid(world, target, pump::getStateForReplace, true);
                    if (result.isSuccess()) {
                        if (!pump.placeFrame) continue;
                        Direction.Plane.HORIZONTAL.m_122557_().map(arg_0 -> ((BlockPos)target).m_142300_(arg_0)).filter(pump.target.getPredicate().negate()).forEach(p -> pump.pumpFluid(world, (BlockPos)p, f -> Holder.BLOCK_FRAME.getDammingState(), false));
                        continue;
                    }
                    break;
                }
            } else if (!pump.target.checkAllFluidsRemoved(world, pos.m_175288_(pump.y))) {
                --pump.y;
                BlockPos nextPos = pos.m_175288_(pump.y);
                if (pump.shouldFinish(world, nextPos)) {
                    pump.finished = true;
                    pump.target = null;
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                    pump.logUsage();
                    if (pump.placeFrame) {
                        TileAdvPump.removeDummyBlock(world, pos, pump.y);
                    }
                } else {
                    pump.target = Target.getTarget(world, nextPos, pump.enchantmentEfficiency.rangePredicate(nextPos), pump::isReplaceBlock, pump.enchantmentEfficiency.areaSize());
                }
            }
        }
    }

    private static void removeDummyBlock(Level level, BlockPos pos, int minY) {
        for (int i = pos.m_123342_() - 1; i > minY; --i) {
            BlockPos withY = pos.m_175288_(i);
            BlockState blockState = level.m_8055_(withY);
            if (blockState.m_60713_((Block)Holder.BLOCK_DUMMY)) {
                level.m_7471_(withY, false);
                break;
            }
            if (!blockState.m_60795_()) break;
        }
    }

    private boolean shouldFinish(Level world, BlockPos nextPos) {
        BlockState blockState = world.m_8055_(nextPos);
        boolean blockCondition = blockState.m_60795_() || blockState.m_60713_((Block)Holder.BLOCK_DUMMY) || this.isReplaceBlock(blockState);
        return world.m_6425_(nextPos).m_76178_() && !blockCondition;
    }

    private BreakResult pumpFluid(Level world, BlockPos target, Function<FluidState, BlockState> replaceBlockGetter, boolean useEnergy) {
        Block block;
        FluidState fluidState = world.m_6425_(target);
        if (fluidState.m_76178_()) {
            return BreakResult.SKIPPED;
        }
        if (!fluidState.m_76170_()) {
            world.m_7731_(target, replaceBlockGetter.apply(fluidState), 3);
            return BreakResult.SUCCESS;
        }
        if (useEnergy && !this.useEnergy(this.enchantmentEfficiency.baseEnergy, PowerTile.Reason.ADV_PUMP_FLUID, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        BlockState blockState = world.m_8055_(target);
        if (!(blockState.m_60734_() instanceof LiquidBlock) && (block = blockState.m_60734_()) instanceof BucketPickup) {
            BucketPickup drain = (BucketPickup)block;
            ItemStack drained = drain.m_142598_((LevelAccessor)world, target, blockState);
            if (!this.deleteFluid) {
                this.storage.addFluid(drained);
            }
        } else {
            if (!this.deleteFluid) {
                this.storage.addFluid(fluidState.m_76152_(), 1000L);
            }
            world.m_7731_(target, replaceBlockGetter.apply(fluidState), 3);
        }
        return BreakResult.SUCCESS;
    }

    public void setEnchantment(EnchantmentEfficiency enchantmentEfficiency) {
        this.enchantmentEfficiency = enchantmentEfficiency;
        this.setMaxEnergy(enchantmentEfficiency.energyCapacity);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sync();
        }
    }

    @NotNull
    private Optional<BlockState> getReplaceModuleState() {
        return this.cache.replaceModuleState.getValue(this.m_58904_());
    }

    private BlockState getStateForReplace(FluidState f) {
        return this.getReplaceModuleState().orElse(f.m_205070_(FluidTags.f_13131_) ? Holder.BLOCK_DUMMY.m_49966_() : Blocks.f_50016_.m_49966_());
    }

    private boolean isReplaceBlock(BlockState state) {
        return state == this.getReplaceModuleState().orElse(Holder.BLOCK_DUMMY.m_49966_());
    }

    public void reset() {
        this.target = null;
        this.finished = false;
        this.y = this.m_58899_().m_123342_() - 1;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantmentEfficiency.getEnchantments();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        List<TextComponent> fluidSummery = this.storage.getFluidMap().entrySet().stream().map(e -> "%s: %d mB".formatted(((FluidKey)e.getKey()).getId(), e.getValue())).map(TextComponent::new).toList();
        List<TextComponent> fluidMessage = fluidSummery.isEmpty() ? List.of(new TextComponent("No Fluid.")) : fluidSummery;
        return Stream.concat(fluidMessage.stream(), Stream.of("%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sRemove:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.deleteFluid), "%sFrame:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.placeFrame), this.energyString()).map(TextComponent::new)).toList();
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        return this.m_187482_();
    }

    public void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.f_58857_);
        }
    }

    void updateModule() {
        Set blockModules = this.f_58857_ != null ? QuarryModuleProvider.Block.getModulesInWorld(this.f_58857_, this.m_58899_()) : Collections.emptySet();
        List<QuarryModule> itemModules = this.moduleInventory.getModules();
        this.modules = Stream.concat(blockModules.stream(), itemModules.stream()).collect(Collectors.toSet());
        if (this.getReplacerModule().isPresent()) {
            this.placeFrame = false;
        }
    }

    static boolean isCapableModule(QuarryModule module) {
        return module instanceof EnergyModuleItem.EnergyModule || module instanceof ReplacerModule || module == QuarryModule.Constant.FILLER;
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    private class AdvPumpCache {
        final CacheEntry<Optional<BlockState>> replaceModuleState = CacheEntry.supplierCache(5L, () -> TileAdvPump.this.getReplacerModule().map(ReplacerModule::getState).filter(Predicate.not(BlockBehaviour.BlockStateBase::m_60795_)).filter(b -> !b.m_60713_((Block)Holder.BLOCK_DUMMY_REPLACER)).or(() -> TileAdvPump.this.hasFillerModule() ? Optional.of(Blocks.f_50069_.m_49966_()) : Optional.empty()));
    }
}

