/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.glue.IVanillaUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(J\u001c\u0010)\u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\rJ\b\u0010,\u001a\u00020\u000bH\u0002J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0002J6\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\r2\u0006\u0010/\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020(J\u001e\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u00105\u001a\u00020\rJ\u000e\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001cJ\u000e\u00108\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001cJ\u000e\u00109\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001cJ\u000e\u0010:\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001cR(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/anti_ad/mc/common/input/GlobalInputHandler;", "", "()V", "value", "Lorg/anti_ad/mc/common/input/IKeybind;", "currentAssigningKeybind", "getCurrentAssigningKeybind", "()Lorg/anti_ad/mc/common/input/IKeybind;", "setCurrentAssigningKeybind", "(Lorg/anti_ad/mc/common/input/IKeybind;)V", "ignoreLeftClick", "", "<set-?>", "", "lastAction", "getLastAction", "()I", "lastKey", "getLastKey", "pressedFirstKey", "pressedKeys", "", "getPressedKeys", "()Ljava/util/Set;", "", "previousPressedKeys", "getPreviousPressedKeys", "registered", "Lorg/anti_ad/mc/common/IInputHandler;", "registeredCancellable", "handleAssignKeybind", "", "isActivated", "keyCodes", "", "settings", "Lorg/anti_ad/mc/common/input/KeybindSettings;", "isKeyDown", "keyCode", "window", "", "isPressing", "isWaitingForRelease", "key", "onInput", "onKey", "action", "scanCode", "modifiers", "checkPressing", "handle", "onMouseButton", "button", "mods", "register", "inputHandler", "registerCancellable", "unregister", "unregisterCancellable", "common"})
public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set registered;
    @NotNull
    private static final Set registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int n2) {
        return pressedKeys.contains(n2);
    }

    public final boolean isActivated(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!keybindSettings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        Set set = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(keybindSettings, set, list2, false, 4, null);
    }

    public final boolean isPressing(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        return keybindSettings.validates(pressedKeys, list2, false);
    }

    private final boolean onKey(int n2, int n3) {
        boolean bl = n3 == 1;
        if (bl && pressedKeys.contains(n2)) {
            return false;
        }
        previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
        if (bl) {
            pressedKeys.add(n2);
        } else {
            pressedKeys.remove(n2);
        }
        lastKey = n2;
        lastAction = n3;
        return this.onInput();
    }

    private final boolean onInput() {
        boolean bl;
        if (currentAssigningKeybind != null) {
            this.handleAssignKeybind();
            return true;
        }
        Object object = registeredCancellable;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((IInputHandler)object.next()).onInput(lastKey, lastAction)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        object = ((Iterable)registered).iterator();
        while (object.hasNext()) {
            ((IInputHandler)object.next()).onInput(lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind iKeybind) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = iKeybind;
    }

    private final void handleAssignKeybind() {
        Object object;
        Object object2 = currentAssigningKeybind;
        if (object2 == null || (object2 = object2.getSettings().getModifierKey().handleKeys(CollectionsKt.toList((Iterable)pressedKeys))) == null) {
            object2 = object = CollectionsKt.toList((Iterable)pressedKeys);
        }
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(CollectionsKt.emptyList());
                }
                this.setCurrentAssigningKeybind(null);
                return;
            }
            IKeybind iKeybind = currentAssigningKeybind;
            if (iKeybind == null) {
                return;
            }
            iKeybind.setKeyCodes((List)object);
            return;
        }
        if (lastKey == -100) {
            ignoreLeftClick = false;
        }
        if (object.isEmpty() && pressedFirstKey) {
            this.setCurrentAssigningKeybind(null);
        }
    }

    public final boolean isKeyDown(int n2, long l2) {
        int n3 = n2;
        if (n2 >= 0) {
            return GLFW.glfwGetKey((long)l2, (int)n2) == 1;
        }
        return (n3 += 100) >= 0 && GLFW.glfwGetMouseButton((long)l2, (int)n3) == 1;
    }

    public final boolean onKey(int n2, int n3, int n4, int n5, boolean bl, long l2) {
        DebugInfos.INSTANCE.onKey(n2, n3, n4, n5);
        if (l2 != 0L && bl && !((Collection)pressedKeys).isEmpty()) {
            Object object = CollectionsKt.toSet((Iterable)pressedKeys);
            pressedKeys.clear();
            object = ((Iterable)object).iterator();
            while (object.hasNext()) {
                n5 = ((Number)object.next()).intValue();
                if (!INSTANCE.isKeyDown(n5, l2)) continue;
                pressedKeys.add(n5);
            }
        }
        switch (n4) {
            case 1: {
                return this.onKey(n2, n4);
            }
            case 0: {
                return this.onKey(n2, n4);
            }
        }
        return false;
    }

    public final boolean onMouseButton(int n2, int n3, int n4) {
        DebugInfos.INSTANCE.onMouseButton(n2, n3, n4);
        switch (n3) {
            case 0: 
            case 1: {
                return this.onKey(n2 >= 0 ? n2 - 100 : n2, n3);
            }
        }
        return false;
    }

    public final boolean register(@NotNull IInputHandler iInputHandler) {
        return registered.add(iInputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler iInputHandler) {
        return registered.remove(iInputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.add(iInputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.remove(iInputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

