/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.rechiseled.RechiseledBlockType;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RechiseledBlockTagsProvider
extends BlockTagsProvider {
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<ResourceLocation, List<Block>> loadedTags = Maps.newHashMap();

    public RechiseledBlockTagsProvider(GatherDataEvent e) {
        super(e.getGenerator(), "rechiseled", e.getExistingFileHelper());
    }

    protected void m_6577_() {
        List<ResourceLocation> tags = Stream.of(BlockTags.f_144280_, BlockTags.f_144281_, BlockTags.f_144282_, BlockTags.f_144283_, BlockTags.f_144286_, BlockTags.f_144285_, BlockTags.f_144284_).map(TagKey::f_203868_).collect(Collectors.toList());
        HashMap tagAppenderMap = Maps.newHashMap();
        tags.forEach(tag -> tagAppenderMap.put(this.loadVanillaTag((ResourceLocation)tag)::contains, this.m_206424_(BlockTags.create((ResourceLocation)tag))));
        for (RechiseledBlockType type : RechiseledBlockType.values()) {
            for (Map.Entry entry : tagAppenderMap.entrySet()) {
                if (!((Predicate)entry.getKey()).test(type.parentBlock.get())) continue;
                if (type.hasCreatedRegularBlock()) {
                    ((TagsProvider.TagAppender)entry.getValue()).m_126582_((Object)type.getRegularBlock());
                }
                if (!type.hasCreatedConnectingBlock()) continue;
                ((TagsProvider.TagAppender)entry.getValue()).m_126582_((Object)type.getConnectingBlock());
            }
        }
    }

    private List<Block> loadVanillaTag(ResourceLocation location) {
        if (this.loadedTags.containsKey(location)) {
            return this.loadedTags.get(location);
        }
        try {
            Resource resource = this.existingFileHelper.getResource(location, PackType.SERVER_DATA, ".json", "tags/blocks");
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(resource.m_6679_()), JsonObject.class);
            JsonArray array = json.getAsJsonArray("values");
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (JsonElement element : array) {
                String name = element.getAsString();
                if (name.charAt(0) == '#') {
                    blocks.addAll(this.loadVanillaTag(new ResourceLocation(name.substring(1))));
                    continue;
                }
                ResourceLocation registryName = new ResourceLocation(name);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
                if (block == null) {
                    throw new JsonParseException("Unknown block '" + registryName + "' in '" + location + "'");
                }
                blocks.add(block);
            }
            this.loadedTags.put(location, blocks);
            return blocks;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

